<?php 
/**
 * $Id: xmap.php 110 2008-02-18 21:14:33Z root $
 * $LastChangedDate: 2008-02-18 15:14:33 -0600 (lun, 18 feb 2008) $
 * $LastChangedBy: root $
 * Xmap by Guillermo Vargas
 * a sitemap component for Joomla! CMS (http://www.joomla.org)
 * Author Website: http://joomla.vargas.co.cr
 * Project License: GNU/GPL http://www.gnu.org/copyleft/gpl.html
*/


#ini_set('display_errors', 1);
#error_reporting(E_ALL);

defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// load Xmap language file


$view = JRequest::getVar('view', 'html' ,"REQUEST");
$task = JRequest::getVar('task', '' ,"REQUEST");

if ($view == 'xslfile') {
	header('Content-Type: application/xml; charset="utf-8"');
	header('Content-Disposition: inline');
	header('Content-Length: ' . filesize(JPATH_COMPONENT_SITE.DS.'gss.xsl'));
	readfile(JPATH_COMPONENT_SITE.DS.'gss.xsl');
	exit;
}



$lang =& JFactory::getLanguage();
$language = $lang->getBackwardLang();
$LangPath = JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS;
if( file_exists( $LangPath . $language . '.php') ) {
	 require_once( $LangPath . $language. '.php' );
} else {
	 require_once( $LangPath . 'english.php' );
}

require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'classes'.DS.'XmapConfig.php' );
require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'classes'.DS.'XmapSitemap.php' );
require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'classes'.DS.'XmapPlugins.php' );
require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'classes'.DS.'XmapCache.php' );

// This is an AJAX request to include or excude an element from the sitemap
if ($task == 'toggleElement') {
	$sitemapid=JRequest::getInt( 'sitemap',0);
	if ($sitemapid) {
		$sitemap = new XmapSitemap($database);
		if ( $sitemap->load($sitemapid) ) {
			$uid = JRequest::getCmd('uid','');
			$itemid = JRequest::getInt('itemid','');
			if ($uid && $itemid) {
				$state = $sitemap->toggleItem($uid,$itemid);
			}
		}
	}

	header('Content-Type: text/xml');
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
	echo "<response>\n";
	echo " <result>OK</result>\n";
	echo " <state>".$state."</state>\n";
	echo "</response>\n";
	exit;
}



global $xSitemap,$xConfig;
$xConfig = new XmapConfig;
$xConfig->load();

$Itemid = intval(JRequest::getVar('Itemid', '' ,"REQUEST"));
$sitemapid =  '';

// Firts lets try to get the sitemap's id from the menu's params
if ( $Itemid ) {
	$menu = JTable::getInstance('Menu');
	$menu->load( $Itemid );
	$params = new JParameter($menu->params );
	$sitemapid=intval($params->get( 'sitemap','' ));
}

if (!$sitemapid) { //If the is no sitemap id specificated
	$sitemapid = intval(JRequest::getVar('sitemap','',"REQUEST"));
}

if ( !$sitemapid && $xConfig->sitemap_default ) {
	$sitemapid = $xConfig->sitemap_default;
}
$database= &JFactory::getDBO();
$xSitemap = new XmapSitemap($database);
$xSitemap->load($sitemapid);

//$database->setQuery('alter table #__xmap_sitemap add excluded_items text');
//$database->query();

if (!$xSitemap->id) {
	echo _XMAP_MSG_NO_SITEMAP;
	return;
}
if ( $view=='xml' ) {
	Header("Content-type: text/xml; charset=UTF-8");
	Header("Content-encoding: UTF-8");
}

global $xmap;

$xmapCache = XmapCache::getCache($xSitemap);

$excluded_items = $xSitemap->getExcludedItems();

if ($xSitemap->usecache) {
	$lang = JFactory::getLanguage();
	$xmapCache->call('xmapCallShowSitemap',$view,$xSitemap->id,$excluded_items,$lang->getName(),$mainframe->getCfg('sef'));	// call plugin's handler function
} else {
	xmapCallShowSitemap($view,$xSitemap->id,$excluded_items);
}

switch ($view) {
	case 'html':
		$xSitemap->views_html++;
		$xSitemap->lastvisit_html = time();
		$xSitemap->save();
	break;

	case 'xml':
		$xSitemap->views_xml++;
		$xSitemap->lastvisit_xml = time();
		$xSitemap->save();

		$scriptname = basename($_SERVER['SCRIPT_NAME']);
		$no_html = intval(JRequest::getVar('no_html', '0',"REQUEST"));
		if ($view=='xml' && $scriptname != 'index2.php' || $no_html != 1) {
			die();
		}
	break;
}

/**
* Function called to generate and generate the tree. Created specially to
* use with the cache call method
* The params locale and sef are only for cache purppses
*/
function xmapCallShowSitemap($view,$sitemapid,$excluded_items,$locale='',$sef='') {
	global $xmapCache,$xSitemap,$xConfig;

	$live_site = substr_replace(JURI::root(), "", -1, 1);

	switch( $view ) {
		case 'xml': 	// XML Sitemaps output
			require_once(JPATH_COMPONENT_SITE .'/xmap.xml.php' );
			$xmap = new XmapXML( $xConfig, $xSitemap );
			$xmap->generateSitemap($view,$xConfig,$xmapCache);
			$xSitemap->count_xml = $xmap->count;
			break;
		default:	// Html output
			global $mainframe;
			require_once( $mainframe->getPath('front_html') );
			if (!$xConfig->exclude_css) {
				$mainframe->addCustomHeadTag( '<link rel="stylesheet" type="text/css" media="all" href="' . $live_site . '/components/com_xmap/css/xmap.css" />' );
			}
			$xmap = new XmapHtml( $xConfig, $xSitemap );
			$xmap->generateSitemap($view,$xConfig,$xmapCache);
			$xSitemap->count_html = $xmap->count;
			break;
	}
}


class Xmap {
	/** @var XmapConfig Configuration settings */
	var $config;
	/** @var XmapSitemap Configuration settings */
	var $sitemap;
	/** @var integer The current user's access level */
	var $gid;
	/** @var boolean Is authentication disabled for this website? */
	var $noauth;
	/** @var string Current time as a ready to use SQL timeval */
	var $now;
	/** @var object Access restrictions for user */
	var $access;
	/** @var string Type of sitemap to be generated */
	var $view;
	/** @var string count of links on sitemap */
	var $count=0;

	/** Default constructor, requires the config as parameter. */
	function Xmap( &$config, &$sitemap ) {
		global $mainframe;

		$user =& JFactory::getUser();

		$access = new stdClass();
		$access->canEdit        = $user->authorize('com_content', 'edit', 'content', 'all');
		$access->canEditOwn     = $user->authorize('com_content', 'edit', 'content', 'own');
		$access->canPublish     = $user->authorize('com_content', 'publish', 'content', 'all');
		$this->access = &$access;

		$this->noauth 	= $mainframe->getCfg( 'shownoauth' );
		$this->gid	= $user->gid;
		$this->now	= (time() - ($mainframe->getCfg('offset') * 60 * 60));
		$this->config = &$config;
		$this->sitemap = &$sitemap;
	}

	/** Generate a full website tree */
	function generateSitemap( $type,&$config, &$cache ) {
		$menus = $this->sitemap->getMenus();
		$extensions = XmapPlugins::loadAvailablePlugins();
		$root = array();
		$this->startOutput($menus,$config);
		foreach ( $menus as $menutype => $menu ) {
			if ( ($type == 'html' && !$menu->show) || ($type == 'xml' && !$menu->showXML ) ) {
				continue;
			}

			$node = new stdclass();
			$menu->id = 0;
			$menu->menutype = $menutype;

			$node->uid = $menu->uid = "menu".$menu->id;
			$node->menutype = $menutype;
			$node->ordering = $menu->ordering;
			$node->priority = $menu->priority;
			$node->changefreq = $menu->changefreq;
			$node->browserNav = 3;
			$node->type = 'separator';
			$node->name = $this->getMenuTitle($menutype);	// get the mod_mainmenu title from modules table

			$this->startMenu($node);
			$this->printMenuTree($menu,$cache,$extensions);
			$this->endMenu($node);
		}
		$this->endOutput($menus);
		return true;
	}

	/** Get a Menu's tree
	 * Get the complete list of menu entries where the menu is in $menutype.
	 * If the component, that is linked to the menuentry, has a registered handler,
	 * this function will call the handler routine and add the complete tree.
	 * A tree with subtrees for each menuentry is returned.
	 */
	function printMenuTree( &$menu, &$cache, $extensions) {
		$database = &JFactory::getDBO();

		if( strlen($menu->menutype) == 0 ) {
			$result = null;
			return $result;
		}

		$menuExluded	= explode( ',', $this->sitemap->exclmenus ); 		// by mic: fill array with excluded menu IDs

		/* * noauth is true:
			- Will show links to registered content, even if the client is not logged in.
			- The user will need to login to see the item in full.
			* noauth is false:
			- Will show only links to content for which the logged in client has access.
		*/
		$sql = "SELECT m.id, m.name, m.parent, m.link, m.type, m.browserNav, m.menutype, m.ordering, m.params, m.componentid, c.name AS component"
	 		. "\n FROM #__menu AS m"
	 		. "\n LEFT JOIN #__components AS c ON m.type='components' AND c.id=m.componentid"
	 		. "\n WHERE m.published='1' AND m.parent=".$menu->id." AND m.menutype = '".$menu->menutype."'"
	 		. ( $this->noauth ? '' : "\n AND m.access <= '". $this->gid ."'" )
	 		. "\n ORDER BY m.menutype,m.parent,m.ordering";

		// Load all menuentries
		$database->setQuery( $sql );
		$items = $database->loadObjectList();

		if( count($items) <= 0) {	//ignore empty menus
			$result = null;
			return $result;
		}

		$this->changeLevel(1);
		
		foreach ( $items as $i => $item ) {		// Add each menu entry to the root tree.
			$item->priority = $menu->priority;
			$item->changefreq = $menu->changefreq;
			if( in_array( $item->id, $menuExluded ) ) {	// ignore exluded menu-items
				continue;
			}

			$node = new stdclass;

			$node->id 		= $item->id;
			$node->uid 		= "itemid".$item->id;
			$node->name 		= $item->name;						// displayed name of node
			$node->parent 		= $item->parent;					// id of parent node
			$node->browserNav 	= $item->browserNav;					// how to open link
			$node->ordering 	= isset( $item->ordering ) ? $item->ordering : $i;	// display-order of the menuentry
			$node->priority 	= $item->priority;
			$node->changefreq 	= $item->changefreq;
			$node->type 		= $item->type;						// menuentry-type
			$node->menutype 	= $item->menutype;					// menuentry-type
			$node->link 	= isset( $item->link ) ? htmlspecialchars( $item->link ) : '';

			XmapPlugins::prepareMenuItem($node,$extensions); 	// Let's see if the extension wants to do somenthing with this node before it's printed

			if (substr($item->link,0,9) == 'index.php' ) {
				if ($item->type == 'menulink') {// For Joomla 1.5 SEF compatibility
					$params = new JParameter($item->params);
					$node->link 	= 'index.php?Itemid=' . $params->get('menu_item');
				}else{
					$node->link 	= 'index.php?Itemid=' . $node->id;
				}
			}

			$this->printNode($node);
			$this->printMenuTree($node,$cache,$extensions);
			XmapPlugins::printTree( $this, $item, $cache, $extensions );	// Determine the menu entry's type and call it's handler			
		}
		$this->changeLevel(-1);
	}

	/** Look up the title for the module that links to $menutype */
	function getMenuTitle($menutype) {
		$database = &JFactory::getDBO();
		$query = "SELECT * FROM #__modules WHERE published='1' AND module='mod_mainmenu' AND params LIKE '%menutype=". $menutype ."%'";
		$database->setQuery( $query );
		if( !$row = $database->loadObject() )
			return '';
		return $row->title;
	}

	function getItemLink (&$node) {
		static $live_site;
                if (!isset($live_site)) {
                        $juri = &JURI::getInstance();
                        $live_site = $juri->getScheme().'://'.$juri->getHost();
                }

		$link = $node->link;
		if ( isset($node->id) ) {
			switch( @$node->type ) {
				case 'separator':
					break;
				case 'url':
					if ( preg_match( "#^/?index\.php\?#", $link ) ) {
						if ( strpos( $link, 'Itemid=') === FALSE ) {
							if (strpos( $link, '?') === FALSE ) {
								$link .= '?Itemid='.$node->id;
							} else {
								$link .= '&amp;Itemid='.$node->id;
							}
						}
					}
					break;
				default:
					if ( strpos( $link, 'Itemid=' ) === FALSE ) {
						$link .= '&amp;Itemid='.$node->id;
					}
					break;
			}
		}
		if( strcasecmp( substr( $link, 0, 4), 'http' ) ){
			if (strcasecmp( substr( $link, 0, 9), 'index.php' ) === 0 ){
				$link = JRoute::_($link);             // apply SEF transformation
				if ( strcasecmp( substr($link,0,4), 'http' ) && $this->view=='xml') {       // XML sitemap requires full path URL's
					$link = $live_site. (substr($link,0,1) == '/'? '' : '/').$link;
				}
			} else { // Case for internal links not starting with index.php
				$link = $live_site. '/' .$link;
			}
		}

		return $link;
	}

	/** called with usort to sort menus */
	function sort_ordering( &$a, &$b) {
		if( $a->ordering == $b->ordering )
			return 0;
		return $a->ordering < $b->ordering ? -1 : 1;
	}

}

