<?php
/**
* @version		1.0.0
* @package		Ambitionality
* @copyright	Copyright (C) 2008 Ambitionality Software LLC. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class plgSearchSimplestForum extends JPlugin
{
    function onSearch($text, $phrase = '', $ordering = '', $areas = null)
    {
        $db = &JFactory::getDBO();
        $user = &JFactory::getUser();
        $params = &JComponentHelper::getParams('com_simplestforum');

        $gid = $user->get('gid');

        if ($gid < $params->get('viewgid')) {
            return;
        }

        if (is_array($areas)) {
            if (!array_intersect($areas, array_keys( $this->onSearchAreas()))) {
                return array();
            }
        }

        $text = trim($text);
        if ($text == '') {
            return array();
        }

        $section = JText::_('FORUM POSTS');

        switch ($phrase) {
            case 'exact':
                $where = '(a.message LIKE '.$db->Quote('%'.$text.'%').' OR a.subject LIKE '.$db->Quote('%'.$text.'%').')';
                break;
            case 'all':
            case 'any':
            default:
                $words = explode(' ', $text);
                $wheres2 = array();
                foreach ($words as $word) {
                    $wheres2[] = '(a.message REGEXP '.$db->Quote('[[:<:]]'.$word.'[[:>:]]').' OR a.subject REGEXP '.$db->Quote('[[:<:]]'.$word.'[[:>:]]').')';
                }
                $where = '('.implode(($phrase == 'all'?' AND ':' OR '), $wheres2).')';
                break;
        }

        switch ($ordering) {
            case 'oldest':
                $order = 'a.date ASC';
                break;
            case 'alpha':
                $order = 'a.subject ASC';
                break;
            case 'category':
            case 'popular':
            case 'newest':
            default:
                $order = 'a.date DESC';
        }

        $query = 'SELECT a.subject AS title, a.message AS text, a.date, a.forumId, 0 AS browsernav, NULL as section, a.date AS created
            FROM #__simplestforum_post AS a
            WHERE '.$where.'
            ORDER BY '.$order
        ;
        $db->setQuery($query);
        $rows = $db->loadObjectList();

        foreach ($rows as $row) {
            $row->href = JRoute::_('index.php?option=com_simplestforum&view=postlist&forumId='.$row->forumId);
        }

        return $rows;
    } //end onSearch

    function onSearchAreas()
    {
        static $areas = array(
            'simplestforumposts' => 'Forum Posts'
        );

        return $areas;
    } //end onSearchAreas

} //end class
?>
