<?php
/**
* @version		1.0.4
* @package		Ambitionality
* @copyright	Copyright (C) 2008 Ambitionality Software LLC. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class plgSystemSimpleCAPTCHA extends JPlugin
{
	function onProcessFormSubmit($postData)
	{
        $mainframe = &JFactory::getApplication();

        $codevarname = $this->params->get('codevarname', 'security_code');

        if ($mainframe->getUserState($codevarname) != $postData[$codevarname]) {
            $postData['form_invalid'] = true;
        }
	} //end onSubmitPost

	function onRenderForm($captchaViewURL)
	{
        $codevarname = $this->params->get('codevarname', 'security_code');
        $instructions = $this->params->get('instructions', 'For security purposes, please type the sequence of numbers below into the provided text box before posting your message. If you can not read the message, please refresh this page.');

        include(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'simplecaptcha'.DS.'formrender.php');
	} //end onRenderPostForm

    function onRenderCAPTCHA()
    {
        $mainframe = &JFactory::getApplication();

	    $font = 'plugins'.DS.'system'.DS.'simplecaptcha'.DS.'monofont.ttf';

        $codevarname = $this->params->get('codevarname', 'security_code');
        $characters = $this->params->get('numchars', '5');
        $width = $this->params->get('width', '100');
        $height = $this->params->get('height', '40');
        $possible = $this->params->get('possiblechars', '23456789bcdfghjkmnpqrstvwxyz');

		$code = $this->_generateCode($characters, $possible);
		/* font size will be 75% of the image height */
		$font_size = $height * 0.75;
		$image = @imagecreate($width, $height) or die('Cannot initialize new GD image stream');
		/* set the colours */
		$background_color = imagecolorallocate($image, 255, 255, 255);
		$text_color = imagecolorallocate($image, 20, 40, 100);
		$noise_color = imagecolorallocate($image, 100, 120, 180);
		/* generate random dots in background */
		for( $i=0; $i<($width*$height)/3; $i++ ) {
			imagefilledellipse($image, mt_rand(0,$width), mt_rand(0,$height), 1, 1, $noise_color);
		}
		/* generate random lines in background */
		for( $i=0; $i<($width*$height)/150; $i++ ) {
			imageline($image, mt_rand(0,$width), mt_rand(0,$height), mt_rand(0,$width), mt_rand(0,$height), $noise_color);
		}
		/* create textbox and add text */
		$textbox = @imagettfbbox($font_size, 0, $font, $code) or die('Error in imagettfbbox function');
		$x = ($width - $textbox[4])/2;
		$y = ($height - $textbox[5])/2;
		imagettftext($image, $font_size, 0, $x, $y, $text_color, $font , $code) or die('Error in imagettftext function');
		/* output captcha image to browser */

        $mainframe->setUserState($codevarname, $code);

        header('Content-Type: image/png', true);
        header('Pragma: no-cache', true);
        header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0', true);
		imagepng($image);
		imagedestroy($image);
        exit;
    } //end 

	function _generateCode($characters, $possible)
    {
		/* list all possible characters, similar looking characters and vowels have been removed */
		$code = '';
		$i = 0;
		while ($i < $characters) { 
			$code .= substr($possible, mt_rand(0, strlen($possible)-1), 1);
			$i++;
		}
		return $code;
	} //end _generateCode

} //end class
