<?php
/**
* @copyright	Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
**/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


function templateAdmin($template_name, $dirname)
{
	$template_task = strval(JREQUEST::getVar('template_task'));
    $id            = intval(JRequest::getVar('id', 0));

    define('_TEMPLATE_NAME', $template_name);
    define('_TMPL_ADMIN_DIRNAME', $dirname);
    define('JPATH_TMPL_ADMIN', dirname(__FILE__));
    define('JPATH_TMPL_BANNER', JPATH_ROOT.DS.'templates'.DS._TEMPLATE_NAME.DS.'banner');
    define('JPATH_TMPL_IMAGES', JPATH_ROOT.DS.'templates'.DS._TEMPLATE_NAME.DS.'images');

    require_once(JPATH_TMPL_ADMIN.DS.'admin.controller.php');
	require_once(JPATH_TMPL_ADMIN.DS.'admin.html.php');
    require_once(JPATH_TMPL_ADMIN.DS.'admin.class.php');

    TemplateAdminHTML::display_jslanguage();

    $force_white = array('add_banner', 'edit_banner', 'edit_images');

    $db = &JFactory::getDBO();

    $query = "CREATE TABLE IF NOT EXISTS #__template_banner (
              id int(11) NOT NULL auto_increment,
              title varchar(124) NOT NULL default '',
              `file` varchar(255) NOT NULL default '',
              menu_item int(11) NOT NULL default '0',
              PRIMARY KEY  (id))";
              $db->setQuery($query);
              $db->query();
    ?>
    <link rel="stylesheet" href="templates/<?php echo _TEMPLATE_NAME;?>/<?php echo _TMPL_ADMIN_DIRNAME;?>/template_admin.css" type="text/css" />
    <?php
    if(in_array($template_task, $force_white))
    {
		?>
		<style type="text/css">
		body { background-color:#fff !important;background-image:none !important; }
		</style>
		<?php
	}

    switch ($template_task)
    {
     	default:
            TemplateAdminController::show_default();
     		break;

     	case 'update_params':
            TemplateAdminController::saveParameters();
            echo "Template parameters have been updated!";
     		break;

     	case 'add_banner':
     		TemplateAdminController::addBanner();
     		break;

     	case 'save_banner':
            TemplateAdminController::saveBanner();
     		break;

     	case 'edit_banner':
            TemplateAdminController::editBanner($id);
     		break;

     	case 'update_banner':
            TemplateAdminController::updateBanner($id);
     		break;

     	case 'delete_banner':
            TemplateAdminController::deleteBanner();
     		break;

     	case 'render_bannermanager':
            TemplateAdminController::renderBannerManager();
     		break;

     	case 'edit_images':
            TemplateAdminController::editImages();
     		break;

     	case 'update_images':
     		TemplateAdminController::updateImages();
     		break;
    }
}
?>