<?php
/**
* @copyright	Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
**/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


class TemplateAdminController
{
	function show_default()
	{
		jimport('joomla.filesystem.path');

		// Initialize some variables
		$template	= _TEMPLATE_NAME;
		$client		=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));

        require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_templates'.DS.'helpers'.DS.'template.php');

		$tBaseDir	= JPath::clean($client->path.DS.'templates');

		if (!is_dir( $tBaseDir . DS . $template )) {
			return JError::raiseWarning( 500, 'Template not found' );
		}

		$lang =& JFactory::getLanguage();
		$lang->load( 'tpl_'.$template, JPATH_ADMINISTRATOR );

		$ini	= $client->path.DS.'templates'.DS.$template.DS.'params.ini';
		$xml	= $client->path.DS.'templates'.DS.$template.DS.'templateDetails.xml';
		TemplatesHelper::parseXMLTemplateFile($tBaseDir, $template);

		jimport('joomla.filesystem.file');

		// Read the ini file
		if (JFile::exists($ini)) {
			$content = JFile::read($ini);
		} else {
			$content = null;
		}

		$params = new JParameter($content, $xml, 'template');

		$template_class = new TemplateAdminClass(_TEMPLATE_NAME);
		$bannerlist = $template_class->loadBannerList();

		TemplateAdminHTML::display_default($params, $bannerlist);
	}


	function renderBannerManager()
	{
		global $mainframe;

        $template_class = new TemplateAdminClass();
		$bannerlist = $template_class->loadBannerList();

		TemplateAdminHTML::display_bannermanager($bannerlist);
		$mainframe->close();
	}


	function saveParameters()
	{
		// Initialize some variables
        $template   = _TEMPLATE_NAME;
		$client		=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
		$params		= JRequest::getVar('params', array(), '', 'array');

		$error = false;
		$template_class = new TemplateAdminClass();

		if (!$template) {
			$error = JText::_("No template specified");
		}

		// Set FTP credentials, if given
		jimport('joomla.client.helper');
		JClientHelper::setCredentialsFromRequest('ftp');
		$ftp = JClientHelper::getCredentials('ftp');

		$file = $client->path.DS.'templates'.DS.$template.DS.'params.ini';

		jimport('joomla.filesystem.file');
		if (JFile::exists($file) && count($params))
		{
			$txt = null;
			foreach ($params as $k => $v) {
				$txt .= "$k=$v\n";
			}

			// Try to make the params file writeable
			if (!$ftp['enabled'] && JPath::isOwner($file) && !JPath::setPermissions($file, '0755')) {
				$error = JText::_("Parameter file is unwriteable");
			}

			JFile::write($file, $txt);

			// Try to make the params file unwriteable
			JPath::setPermissions($file, '0555');
		}
		else {
			$error = JText::_("Parameter file does not exist");
		}
		$message = JText::_("The parameters have been updated");

		$template_class->_error = $error;
		$template_class->showMessage($message);
	}


	function addBanner()
	{
		global $mainframe;

        $template_class = new TemplateAdminClass();

        $rows = $template_class->loadMenuItems();

        TemplateAdminHTML::display_addBanner($rows);

        $mainframe->close();
	}


	function editBanner($id)
	{
		global $mainframe;

        $template_class = new TemplateAdminClass();

        $rows = $template_class->loadMenuItems();
        $row  = $template_class->loadBanner($id);

        TemplateAdminHTML::display_editBanner($rows, $row);

        $mainframe->close();
	}


	function saveBanner()
	{
        $template_class = new TemplateAdminClass();

        $banner    = JRequest::getVar('banner', '', 'FILES');
        $tmp_file  = $banner['tmp_name'];
        $file_name = $banner['name'];
        $cids   = JRequest::getVar('cid', array());

        $template_class->validate_addBanner($tmp_file, $cids);

        if(!$template_class->_error) {
        	$message = $template_class->saveBanner($tmp_file, $file_name, $cids);
        }

        $template_class->showMessage($message);
	}


	function deleteBanner()
	{
		$cids   = JRequest::getVar('cid', array());
		$template_class = new TemplateAdminClass();

		$message = $template_class->deleteBanners($cids);

		$bannerlist = $template_class->loadBannerList();

		TemplateAdminHTML::display_bannermanager($bannerlist);

		$template_class->showMessage($message);
	}


	function updateBanner($id)
	{
        $template_class = new TemplateAdminClass();

        $banner    = JRequest::getVar('banner', '', 'FILES');
        $tmp_file  = $banner['tmp_name'];
        $file_name = $banner['name'];
        $cids      = JRequest::getVar('cid', array());

        $template_class->validate_updateBanner($tmp_file, $cids);

        if(!$template_class->_error) {
        	$message = $template_class->updateBanner($tmp_file, $file_name, $cids, $id);
        }

        $template_class->showMessage($message);
	}


	function editImages()
	{
		global $mainframe;

		$template_class = new TemplateAdminClass();

		$images = $template_class->loadImageDir();

		TemplateAdminHTML::display_images($images);

		$mainframe->close();
	}


	function updateImages()
	{
		$template_class = new TemplateAdminClass();


		$images = $template_class->loadImageDir();

        foreach ($images AS $i => $image_name)
        {

            $image = JRequest::getVar("image_".$i, '', 'FILES');
            $tmp = $image['tmp_name'];
            echo $tmp;
        	if(@getimagesize($tmp)) {
        		$message = $template_class->updateImage($tmp, $image_name);
        	}
        }

        $template_class->showMessage($message);
	}
}
?>