<?php
/**
 * @copyright   Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
 * @license      GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once 'lib.php';

$left      = $this->countModules('left');
$right     = $this->countModules('right');
$syndicate = $this->countModules('syndicate');
$top       = $this->countModules('top');
$user1     = $this->countModules('user1');
$user2     = $this->countModules('user2');
$user3     = $this->countModules('user3');
$user4     = $this->countModules('user4');

$mode               = $this->params->get('mode', 'wide');
$generallink        = getValidColor($this->params->get('generallink', '#3169A1'), '#3169A1');
$generalvisitedlink = getValidColor($this->params->get('generalvisitedlink', '#6931A1'), '#6931A1');
$titlecolor         = getValidColor($this->params->get('titlecolor', '#6699CC'), '#6699CC');
$leftcolumn         = getValidColor($this->params->get('leftcolumn', '#FFFFEE'), '#FFFFEE');
$rightcolumn        = getValidColor($this->params->get('rightcolumn', '#DDEEFF'), '#DDEEFF');

$leftcolor       = getValidColor($this->params->get('leftcolor', '#009900'), '#009900');
$lefttext		 = getValidColor($this->params->get('lefttext', '#000000'), '#000000');
$leftlink        = getValidColor($this->params->get('leftlink', '#FFFFFF'), '#FFFFFF');
$leftvisitedlink = getValidColor($this->params->get('leftvisitedlink', '#007700'), '#007700');

$rightcolor       = getValidColor($this->params->get('rightcolor', '#3179C8'), '#3179C8');
$righttext		  = getValidColor($this->params->get('righttext', '#000000'), '#000000');
$rightlink        = getValidColor($this->params->get('rightlink', '#FFFFFF'), '#FFFFFF');
$rightvisitedlink = getValidColor($this->params->get('rightvisitedlink', '#556677'), '#556677');

$verticalbg      = getValidColor($this->params->get('verticalmenubg', '#FFFFFF'), '#FFFFFF');
$verticalborder  = getValidColor($this->params->get('verticalmenuborder', '#3179C8'), '#3179C8');
$verticallink    = getValidColor($this->params->get('verticalmenulink', '#777777'), '#777777');
$verticalhover   = getValidColor($this->params->get('verticalmenuhover', '#2D8523'), '#2D8523');
$verticalactive  = getValidColor($this->params->get('verticalmenuactive', '#009900'), '#009900');

$display_logo    = $this->params->get('displaylogo', true);
$logo            = $this->baseurl.'/'.$this->params->get('logo', '');
$sitename        = $mainframe->getCfg('sitename');
$slogan          = $this->params->get('slogan', '');

$footerlink        = getValidColor($this->params->get('footerlink', '#FFFFFF'), '#FFFFFF');
$footervisitedlink = getValidColor($this->params->get('footervisitedlink', '#CCCCCC'), '#CCCCCC');

$showtop         = $this->params->get('top', 1);
$showbreadcrumbs = $this->params->get('breadcrumbs', 1);
$showuser1       = $this->params->get('user1', 1);
$showuser2       = $this->params->get('user2', 1);
$showuser3       = $this->params->get('user3', 1);
$showuser4       = $this->params->get('user4', 1);
$showfooter      = $this->params->get('footer', 0);
$showbanner      = $this->params->get('banner', 1);
$showsyndicate   = $this->params->get('syndicate', 1);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" >
<head>
<jdoc:include type="head" />
<link rel="stylesheet" type="text/css" href="<?php echo $this->baseurl; ?>/templates/system/css/system.css" />
<link rel="stylesheet" type="text/css" href="<?php echo $this->baseurl; ?>/templates/system/css/general.css" />
<link rel="stylesheet" type="text/css" href="<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/css/template.css" />
<?php if ($mode == 'wide') : ?><link rel="stylesheet" type="text/css" href="<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/css/wide.css" /><?php endif; ?>
<style type="text/css">
<?php if ($display_logo) : ?>div#logo,div#logo-png{background-image:url(<?php echo $logo ?>);}<?php endif; ?>
<?php if (($user1 and $showuser1) xor ($user2 and $showuser2)) : ?>#middlebar #user1,#middlebar #user2{width:98%;float:left;}<?php endif; ?>
<?php if ($generallink != '#3169A1') : ?>a, a:link, a.readon:hover,a.readon:visited {color:<?php echo $generallink; ?>;}<?php endif; ?>
<?php if ($generalvisitedlink != '#6931A1') : ?>a:visited{color:<?php echo $generalvisitedlink; ?>;}<?php endif; ?>
<?php if ($leftcolor != '#009900') : ?>div#sidebar-left div.module,#footer-left-bg,#header-left,.button,button,#sidebar-right .button,#sidebar-right button{background-color:<?php echo $leftcolor; ?>}<?php endif; ?>
<?php if ($rightcolor != '#3179C8') : ?>div#sidebar-right div.module,#header-background,#footer-background,#sidebar-left .button,#sidebar-left button{background-color:<?php echo $rightcolor; ?>}<?php endif; ?>
<?php if ($leftlink != '#FFFFFF') : ?>#sidebar-left a,#sidebar-left a:link{color:<?php echo $leftlink; ?>;}<?php endif; ?>
<?php if ($leftvisitedlink != '#007700') : ?>#sidebar-left a:visited{color:<?php echo $leftvisitedlink; ?>;}<?php endif; ?>
<?php if ($rightlink != '#FFFFFF') : ?>#sidebar-right a,#sidebar-right a:link{color:<?php echo $rightlink; ?>;}<?php endif; ?>
<?php if ($rightvisitedlink != '#556677') : ?>#sidebar-right a:visited{color:<?php echo $rightvisitedlink; ?>;}<?php endif; ?>
<?php if ($titlecolor != '#6699CC') :?>div.componentheading,table.contentpaneopen td.contentheading,h1,h2,h3,h4,h5,h6,.pagenavcounter{color: <?php echo $titlecolor; ?>;}<?php endif; ?>
<?php if ($leftcolumn != '#FFFFEE') :?>#middlebar #user1,.article_column{background-color:<?php echo $leftcolumn; ?>;}<?php endif; ?>
<?php if ($rightcolumn != '#DDEEFF') :?>#middlebar #user2,.column_separator{background-color:<?php echo $rightcolumn; ?>;}<?php endif; ?>
<?php if ($footerlink != '#FFFFFF') : ?>#footer a:link{color:<?php echo $footerlink; ?>;}<?php endif; ?>
<?php if ($footervisitedlink != '#CCCCCC') : ?>#footer a:visited{color:<?php echo $footervisitedlink; ?>;}<?php endif; ?>
<?php if ($verticalbg != '#FFFFFF') : ?>div#vertical-menu-holder-inner{background-color:<?php echo $verticalbg; ?>;}<?php endif; ?>
<?php if ($verticalborder != '#3179C8') : ?>div#vertical-menu-border-top,div#vertical-menu-border-bottom{background-color:<?php echo $verticalborder; ?>;}<?php endif; ?>
<?php if ($verticallink != '#777777') : ?>a.mainlevel-nav,a.mainlevel-nav:link,a.mainlevel-nav:visited{color:<?php echo $verticallink;?>}<?php endif; ?>
<?php if ($verticalhover != '#2D8523') : ?>a#active_menu-nav,a#active_menu-nav:link,a#active_menu-nav:visited,a.mainlevel-nav:hover,a#active_menu-nav:hover{color:<?php echo $verticalhover; ?>;}<?php endif; ?>
<?php if ($verticalactive != '#009900') : ?>a.mainlevel-nav:active,a#active_menu-nav:active{color:<?php echo $verticalactive; ?>;}<?php endif; ?>
<?php if ($lefttext != '#000000') : ?>#sidebar-left{color:<?php echo $lefttext; ?>;}<?php endif; ?>
<?php if ($righttext != '#000000') : ?>#sidebar-right{color:<?php echo $righttext; ?>;}<?php endif; ?>
#header-fix1{background:url(<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/ellipse.php?color=<?php echo str_replace('#', '', $rightcolor); ?>) no-repeat;}
#header-fix2{background:url(<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/ellipse.php?color=<?php echo str_replace('#', '', $leftcolor); ?>) no-repeat;}
#footer-fix1{background:url(<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/smallEllipse.php?color=<?php echo str_replace('#', '', $rightcolor); ?>) no-repeat;}
#footer-fix2{background:url(<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/smallEllipse.php?color=<?php echo str_replace('#', '', $leftcolor); ?>) no-repeat;}
</style>
<!--[if lt IE 7]>
<link rel="stylesheet" type="text/css" href="<?php echo $this->baseurl; ?>/templates/<?php echo $this->template ?>/css/fix-ie.css" />
<style type="text/css">
.button,button{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/button.png');}
#header-limiter div{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/top_limiter.png');}
#footer-limiter div{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/footer_limiter.png');}
#header-trans{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/trans_top.png');}
#header-limiter{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/trans_top_ellips.png');}
#header-fix1{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/ellipse.php?color=<?php echo str_replace('#', '', $rightcolor); ?>');}
#header-fix2{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/ellipse.php?color=<?php echo str_replace('#', '', $leftcolor); ?>');}
#footer-trans{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/trans_bot.png');}
#footer-fix1{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/smallEllipse.php?color=<?php echo str_replace('#', '', $rightcolor); ?>');}
#footer-fix2{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/smallEllipse.php?color=<?php echo str_replace('#', '', $leftcolor); ?>');}
#footer-right-corner{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/trans_bot_right.png');}
#footer-left-corner{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/trans_bot_left.png');}
div.sidebar div.module .module-repeatable{background-image:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/module.png');}
div.sidebar div.module .module-top{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/module_top.png');}
div.sidebar div.module .module-repeatable .module-content-top{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/module_content_top.png');}
div.sidebar div.module .module-repeatable .module-content{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/module_content.png');}
div.sidebar div.module .module-bottom{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/module_bottom.png');}
div#vertical-menu-holder-inner{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/vertical_menu.png');}
div#vertical-menu-border-top{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/vertical_menu_border_top.png');}
div#vertical-menu-border-bottom{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $this->baseurl; ?>/templates/<?php echo $this->template; ?>/images/vertical_menu_border_bottom.png');}
<?php if (strtolower(substr($logo, -4)) == '.png') : ?>div#logo-png{background-image:none;background-color:none;filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=scale,src='<?php echo $logo; ?>');}<?php endif; ?>
<?php if ($mode == narrow) : ?>#header-limiter{left:-115px;padding-left:115px;}<?php endif; ?>
</style>
<![endif]-->
</head>

<body>
<div id="container">
	<div id="header">
		<div id="header-background">
			<div id="header-left">
				<div id="header-fix1"></div>
				<div id="header-fix2"></div>
			</div>
			<div id="header-trans"></div>
			<div id="header-limiter">
				<div></div>
			</div>
		</div>
		<div id="subheader">
			<div id="identity">
				<?php if ($display_logo) : ?>
				<div id="logo<?php echo (strtolower(substr($logo, -4)) == '.png') ? '-png' : ''; ?>"></div>
				<?php endif; ?>
				<div id="sitename">
					<table>
						<tr>
							<td valign="middle">
								<div id="sitename-main"><a href="<?php echo $this->baseurl; ?>/" title="<?php printf(JText::_('HOME_PAGE'), $sitename); ?>"><?php echo $sitename; ?></a></div>
								<?php if ($slogan) : ?>
								<div id="slogan"><?php echo $slogan; ?></div>
								<?php endif; ?>
							</td>
						</tr>
					</table>
				</div>
				<div class="clear"></div>
			</div><!-- END IDENTITY -->
			<?php if ($showuser4 and $user4) : ?>
			<div id="user4">
				<jdoc:include type="modules" name="user4" style="none" />
			</div>
			<?php endif; ?>
		</div><!-- END SUB HEADER -->
	</div><!-- END HEADER -->

	<?php if ($user3 and $showuser3) : ?>
	<div id="vertical-menu-holder">
		<div id="vertical-menu-border-top"></div>
		<div id="vertical-menu-holder-inner">
			<jdoc:include type="modules" name="user3" style="xhtml" />
		</div><!-- END VERTICAL MENU HOLDER CONTENT-->
		<div id="vertical-menu-border-bottom"></div>
	</div><!-- END VERTICAL MENU HOLDER -->
	<?php endif; ?>

	<?php if ($showbanner == 'top' || $showbanner == 'both') : ?>
	<jdoc:include type="modules" name="banner" />
	<?php endif; ?>

	<?php if ($showbreadcrumbs) : ?>
	<jdoc:include type="module" name="breadcrumbs" />
	<?php endif; ?>

	<div id="wrapper">
		<?php if ($left or ($syndicate and $showsyndicate)) : ?>
		<div id="sidebar-left" class="sidebar float-left">
			<jdoc:include type="modules" name="left" style="sidebar" />
			<?php if ($syndicate and $showsyndicate) :?>
			<jdoc:include type="modules" name="syndicate" style="sidebar" />
			<?php endif; ?>
		</div>
		<?php endif; ?><!-- END LEFT SIDEBAR -->

		<?php if ($right or ($top and $showtop)) : ?>
		<div id="sidebar-right" class="sidebar float-right">
			<?php if ($showtop) : ?>
			<jdoc:include type="modules" name="top" style="sidebar" />
			<?php endif; ?>
			<jdoc:include type="modules" name="right" style="sidebar" />
		</div>
		<?php endif; ?><!-- END RIGHT SIDEBAR -->

		<?php
		if (($left || ($syndicate and $showsyndicate)) xor ($right || ($top and $showtop))) {
			$column = 2;
		} elseif (($left || ($syndicate and $showsyndicate)) and ($right || ($top and $showtop))) {
			$column = 3;
		} else {
			$column = 1;
		}
		?>

		<?php if ($column == 2) : ?>
		<div id="middlebar" class="two-column">
		<?php elseif ($column == 3) : ?>
		<div id="middlebar" class="three-column">
		<?php else : ?>
		<div id="middlebar" class="one-column">
		<?php endif; ?>

			<jdoc:include type="message" />

			<?php if($user1 || $user2) : ?>
			<div id="user12">
				<?php if($user1 and $showuser1) : ?>
				<div id="user1">
					<jdoc:include type="modules" name="user1" style="minimal" />
				</div>
				<?php endif; ?>

				<?php if($user2 and $showuser2) : ?>
				<div id="user2">
					<jdoc:include type="modules" name="user2" style="minimal" />
				</div>
				<?php endif; ?>

				<?php if (($user1 and $showuser1) || ($user2 and $showuser2)) : ?>
				<div class="clr"></div>
				<?php endif; ?>
			</div>
			<?php endif; ?>

			<jdoc:include type="component" style="xhtml" />
		</div><!-- END MIDDLEBAR -->
		<div class="clear"></div>

		<?php if ($showbanner == 'bottom' || $showbanner == 'both') : ?>
		<jdoc:include type="modules" name="banner" />
		<?php endif; ?>

		<div id="back-to-top" class="center"><a href="#"><?php echo JText::_('TOP_OF_PAGE'); ?></a></div>
	</div><!-- END WRAPPER -->

	<div id="footer">
		<div id="footer-background">
			<div id="footer-left-bg">
				<div id="footer-fix1"></div>
				<div id="footer-fix2"></div>
			</div>
			<div id="footer-trans"></div>
			<div id="footer-limiter">
				<div></div>
			</div>
		</div>
		<div id="footer-cover">
			<div id="footer-left-corner"></div>
			<div id="footer-right-corner"></div>

			<div id="footer-left">
				Powered by <a href="http://www.joomla.org">Joomla! 1.5</a> | Template by <a href="mailto:my_beatman@yahoo.com">Manda Yugana</a><br />Validate <a href="http://validator.w3.org/check/referer">XHTML</a> | <a href="http://jigsaw.w3.org/css-validator/check/referer">CSS</a>
			</div><!-- END FOOTER-LEFT -->

			<div id="footer-right">
				<?php if ($showfooter) : ?>
				<jdoc:include type="modules" name="footer" />
				<?php endif; ?>
			</div><!-- END FOOTER-RIGHT -->
			<div class="clear"></div>
		</div>
	</div><!-- END FOOTER -->
</div>
<jdoc:include type="modules" name="debug" />
</body>
</html>