<?php
/**
 * @version		$Id: pagination.php 1000 2007-09-19 05:43:29Z gantenx $
 * @package		Joomla
 * @copyright	Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

function pagination_list_render($list)
{
	$html = "<span class=\"pagination\">";
	$html .= "<ul>";

	$html .= $list['start']['data'];
	$html .= $list['previous']['data'];

	foreach( $list['pages'] as $page ) {
		if($page['data']['active']) $html .= '<strong>';
		$html .= $page['data'];
		if($page['data']['active']) $html .= '</strong>';
	}

	$html .= $list['next']['data'];
	$html .= $list['end']['data'];

	$html .= "</ul>";
	$html .= "<div class=\"clear\">";
	$html .= "</span>";
	return $html;
}

function pagination_item_active(&$item) {
	$html = "<li><a href=\"".$item->link."\" title=\"".$item->text."\">";
	if ($item->text == JText::_('START')) $html .= '&laquo; ';
	$html .= $item->text;
	if ($item->text == JText::_('END')) $html .= ' &raquo; ';
	$html .= "</a></li>";
	return $html;
}

function pagination_item_inactive(&$item) {
	$html = "<li>";
	if ($item->text == JText::_('START')) $html .= '&laquo; ';
	$html .= $item->text;
	if ($item->text == JText::_('END')) $html .= ' &raquo; ';
	$html .= "</li>";
	return $html;
}
?>