var Site = {
	start: function(){
		Site.Modules();
		Site.Menu();
		Site.Table();
	},
	
	Modules: function(){
		var modules = $$('.cont');
		var toggles = $$('.tog');
		modules.each( function(mod, index){
			var Slide = new Fx.Slide( mod, { duration:800, wait:false, transition:Fx.Transitions.Quart.easeOut }).hide();
			var fx = new Fx.Style( mod, 'opacity', { duration:800, wait:false }).set(0);
			
			toggles[index].addEvent('click', function(e){
				e = new Event(e).stop();
				Slide.toggle();
				if( Slide.wrapper.offsetHeight == 0 ){
					fx.start(0, 1);	
				}
				else{
					fx.start(0, 1);
				}
			});
		});
	},
	
	Menu: function(){
		var entries = $$('.moduletable_menu li a');
		entries.each( function(el){
			var fx = new Fx.Styles( el, { duration:300, wait:false });
			
			el.addEvent('mouseenter', function(){
				fx.start({
					'background-color':'#E8E8E8',
					'color':'#888',
					'padding-left':8
				});
			});
			el.addEvent( 'mouseleave', function(){
				fx.start({
					'background-color':'#F9F9F9',
					'color':'#333',
					'padding-left':0
				});
			});
		});
	},
	
	Table: function(){
		var rows1 = $$('.sectiontableentry1');
		rows1.each( function( row1 ){
			var fx = new Fx.Styles( row1, { duration:300, wait:false } );
			row1.addEvent( 'mouseenter', function(){
				fx.start({
					'background-color': '#333',
					'color': '#fff'
				});
			});
			row1.addEvent( 'mouseleave', function(){
				fx.start({
					'background-color': '#fff',
					'color': '#333'
				});
			});
		});
		
		var rows2 = $$('.sectiontableentry2');
		rows2.each( function( row2 ){
			var fx2 = new Fx.Styles( row2, { duration:300, wait:false } );
			row2.addEvent( 'mouseenter', function(){
				fx2.start({
					'background-color': '#333',
					'color': '#fff'
				});
			});
			row2.addEvent( 'mouseleave', function(){
				fx2.start({
					'background-color': '#F8F8F8',
					'color': '#333'
				});
			});
		});
	}
}
window.addEvent('domready', Site.start );