<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

defined('_JEXEC') or die('Restricted access'); // no direct access 

class JAMTMessages
{
	/**
	 * Build the messagelist
	 *
	 * @parram object	$rows. Contains the info from the database
	 * @access			public
	 * @return			string
	 */
	function Messageslist($rows)
	{
		$usersettings	=& JAMConfig::getUserSettings();
		$user			=& JFactory::getUser();

		$user_id		= $user->get('id');
		$string			= '';
		$k				= 2;

		for ($i = 0, $n = count($rows); $i < $n; $i++)
		{
			$row			=& $rows[$i];

			// Class and images
			$class = '';
			$images = '';
			if ($row->sid != $user_id)
			{
				if (!$row->state) {
					$class .= 'jam-message-mnew';
					$images .= '<div class="jam-message-new"></div>';
				} else {
					$images .= '<div class="jam-message-read"></div>';
				}
			}
			if ($row->priority == '3') {
				$images .= '<div class="jam-message-prhigh"></div>';
			}
			if ($row->priority == '1') {
				$images .= '<div class="jam-message-prlow"></div>';
			}
			if ($row->system) {
				$images .= '<div class="jam-message-system"></div>';
			}
			if ($row->attachments) {
				$images .= '<div class="jam-message-attachments"></div>';
			}

			// Username(s)
			if ($row->sid == $user_id) {
				$username = JText::_( 'To').': '.$row->user;
				if ($row->draft) {
					$username = $row->user;
				}
			} else {
				$username = JText::_('From').': '.$row->user;
			}

			// Subject-messagepart
			$part		= $row->subject.' - '.$row->message;

			// Read by receivers
			if ($row->sid == $user_id && !$row->draft) {
				$read = $row->read.' / '.$row->readt;
			} else {
				$read = '';
			}

			// Build the row
			$string	.= '<li class="jam-row jam-row'.$k.'">' .
						'<table width="100%" cellpadding="0" cellspacing="0">' .
							'<tr>' .
								'<td width="16px"><input type="checkbox" id="cb'.$i.'" name="mid[]" value="'.$row->id.'" onclick="isChecked(this.checked);" /></td>' .
								'<td><a '.$row->link.' class="jam-message '.$class.'">' .
									'<table width="100%">' .
										'<tr>' .
											'<td width="36px">'.$images.'</td>' .
											'<td>' .
												'<div class="jam-message-overflow">'.$username.'</div>' .
												'<div class="jam-message-overflow">'.$part.'</div>' .
											'</td>' .
											'<td class="jam-message-right">'.$read.'<br />'.$row->datetime.'</td>' .
										'</tr>' .
									'</table>' .
								'</a></td>' .
							'</tr>' .
						'</table>' .
					"</li>\n";

			$k = 2 / $k;
		}

		return $string;
	}
}
?>