<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

defined('_JEXEC') or die('Restricted access'); // no direct access 

class JAMTMenus
{
	/**
	 * Menu
	 *
	 * @param 	string	$viewName.
	 * @acces	public
	 * @return	string
	 */
	function Main($viewName)
	{
		$items	= JAMHtml::Mainmenu($viewName);
		$output	= '<div class="jam-menu"><ul>';

		for ($i = 0; $i < 6; $i++)
		{
			$item	= $items[$i];
			$span	= $item->active ? ' class="jam-menu-active"' : '';
			$name	= JText::_( $item->name );
			$output	.= "<li><a $item->link><span$span>$name</span></a></li>";
		}

		$output .= '</ul></div>';

		return $output;
	}
	
	/**
	 * Actionmenu
	 *
	 * @param 	array	$array. Contains the items
	 * @access	public
	 * @return	string
	 */
	function Actions($array)
	{
		$output	= '<div class="jam-actionmenu"><ul>';

		for ($i = 0, $t = count($array); $i < $t; $i++)
		{
			$item = $array[$i];
			$name = JText::_( $item->name );

			if ($item->link) {
				$output .= "<li><a $item->link>$name</a>";
			} else {
				$output .= "<li class=\"haschildren\">$name";
			}

			if ($item->children)
			{
				$output .= '<ul>';

				for ($c = 0, $tc = count($item->children); $c < $tc; $c++)
				{
					$child	= $item->children[$c];
					$name	= JText::_( $child->name );

					if ($child->link)
					{
						if ($child->external) {
							$output .= "<li><a $child->link onclick=\"popupWindow(this.href, '', 640, 480, 1);return false;\">$name</a></li>";
						} else {
							$output .= "<li><a $child->link>$name</a></li>";
						}
					} else
					{
						$output .= "<li>$name</li>";
					}
				}

				$output .= '</ul>';
			}

			$output .= '</li>';
		}

		$output .= '</ul></div>';

		return $output;
	}
}
?>