<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewUsersearch extends JView
{
	function display( $tpl = null)
	{
		$user		=& JFactory::getUser();
		$model      =& JAMLoad::Object( 'model', 'usersearch', 'site' );

		$search		= JRequest::getVar( 'search', false);
		$all		= JRequest::getVar( 'all', false);
		$limitstart	= JRequest::getVar( 'limitstart', '0', 'GET', 'int');

		if ( $all ) {
			$config	=& JAMConfig::getConfig();
			if( $config->get( 'userlist_'.$user->get('gid') ) ) {
				$search = '';
			}
		}

		if ($search || $all)
		{
			// Get the total number of searched usernames
			$total		= $model->countUsernames($search);

			// Create the pagination object
			JAMLoad::_( 'helper', 'usersearch', 'site' );
			$url = $all ? '&all=1' : '&search='.$search;
			$pagination = new JAMUsersPagination($total, $limitstart, 10, $url);

			$usernames	= $model->SearchUsernames( $search, $limitstart, 10);

			$this->assign( 'pageNav', $pagination);
		}

		$this->assign( 'usernames', (isset($usernames) ? $usernames : false));

		parent::display($tpl);
	}
}
?>