<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewTrash extends JView
{
	function display( $tpl = null)
	{
		JAMLoad::_( 'helper', 'trash', 'site' );
		$config		=& JAMConfig::getConfig();
		$model      =& JAMLoad::Object( 'model', 'trash', 'site' );
		$where		= array();
		$option		= 'jam.trash';

		// Get some variables
		global $mainframe;
		$search				= $mainframe->getUserStateFromRequest("$option.search", 'search', '');
		$filter_tag			= $mainframe->getUserStateFromRequest("$option.tag", 'filter_tag', '');
		$filter_state		= $mainframe->getUserStateFromRequest("$option.filter_state", 'filter_state', 0);
		$filter_order		= $mainframe->getUserStateFromRequest("$option.filter_order", 'filter_order', 'm.datetime');
		$filter_order_Dir	= $mainframe->getUserStateFromRequest("$option.filter_order_Dir", 'filter_order_Dir', 'DESC');
		$limit				= $mainframe->getUserStateFromRequest("$option.limit", 'limit', $mainframe->getCfg( 'list_limit'), 0);
		$limitstart			= JRequest::getVar('limitstart', '0', 'POST', 'int');

		// Tags
		if ($filter_tag) {
			$mids	= $model->getMessageIdsByTag($filter_tag);
			$where[]= JAMHelperTrash::Filter_tags($mids);
		}

		// Message filter
		if ($filter_state != 0) {
			$where[] = JAMHelperTrash::Filter_state($filter_state);
		}

		// Search
		if ($search) {
			$where[] = JAMHelperTrash::SQLSearch($search);
		}

		// Ordering
		$order = $filter_order.' '.$filter_order_Dir;

		// Get the total number of filtered messages
		$total = $model->countMessages($where);

		// Create the pagination object
		JAMLoad::_( 'includes', 'pagination', 'site' );
		$pagination = new JAMPagination($total, $limitstart, $limit);

		// Get the messages
		$rows = $model->getMessages($where, $order, $limitstart, $limit);
		$rows = JAMHelperTrash::Process($rows);

		// Search filter
		$lists['search'] = $search;

		// Tags filter
		$tags			= $model->getTags();
		$lists['tags']	= JAMHelperTrash::Filter_tags_html( $tags, $filter_tag);

		// Messages filter
		$lists['state'] = JAMHelperTrash::Filter_state_html( $filter_state);

		// Table ordering
		$lists['order']		= JAMHelperTrash::Filter_order_html($filter_order);
		$lists['order_Dir']	= JAMHelperTrash::Filter_order_Dir_html($filter_order_Dir);

		// The items of the action menu
		$actions = JAMHelperTrash::MenuItems($tags);

		// How much messages left to receive?
		$amount	= $model->countTotal();
		$left	= JAMHelperTrash::MessagesLeft($amount);

		$this->assign( 'rows'		, $rows);
		$this->assign( 'lists'		, $lists);
		$this->assign( 'pageNav'	, $pagination);
		$this->assign( 'left'		, $left);
		$this->assign( 'actions'	, $actions);
		$this->assign( 'limitstart'	, $limitstart);

		parent::display($tpl);
	}
}
?>