<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewRead extends JView
{
	function display( $tpl = null)
	{
		JAMLoad::_( 'helper', 'read', 'site' );
		$config		=& JAMConfig::getConfig();
		$usersettings= JAMConfig::getUserSettings();
		$model      =& JAMLoad::Object( 'model', 'read', 'site' );
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');

		$mid		= JRequest::getVar( 'id', 0, '', 'INT');
		$action		= JRequest::getVar( 'action', false, 'POST', 'WORD');
		$params		= array();

		// Get the message
		$result = $model->getMessage($mid);
		if (!isset($result->id)) {
			exit ('<script>alert("'.JText::_( 'ALERTNOTAUTH', true).'");document.close();</script>');
		}
		
		// Get the user's ids and (user)names
		if ($result->rid == $user_id)
		{
			$select	= $config->get('displayuser');
			$sender	=& JFactory::getUser($result->sid);
			if ($select == '1') {
				$sender = $sender->get('username');
			} else if ($select == '2') {
				$sender = $sender->get('name');
			} else if ($select == '3') {
				$sender = $sender->get('username').' ('.$sender->get('name').')';
			} else if ($select == '4') {
				$sender = $sender->get('name').' ('.$sender->get('username').')';
			}

			$ids = array($result->sid);
			$result->user = $sender;
		}
		else 
		{
			$data	= $model->getUser($mid);
			$ids	= array();
			$users	= null;
			for ($i = 0, $t = count($data), $l = $t-1; $i < $t; $i++)
			{
				$ids[] = $data[$i]['id'];
				$users .= $data[$i]['user'];
				if ($i < $l) {$users .= ', ';}
			}
			$result->user = $users;
		}

		// Set message to read if needed
		if ($result->rid == $user_id && !$result->state && !$action) {
			$model->SetRead($mid);
			$result->state = '1';
		}

		// Tags of the message
		$tags	=& $model->getTagsByMessage($mid);
		$result->tags = JAMHelperRead::Tags($tags);

		// Convert the messagetime into the user's timezone and the user's date format
		$result->datetime = JHTML::Date( $result->datetime, $usersettings->dateformat, $user->getParam('timezone', '0') );

		// Convert the priority into text
		if ($result->priority == '3') {
			$result->priority = JText::_('High');
		} else if ($result->priority == '1') {
			$result->priority = JText::_('Low');
		} else {
			$result->priority = JText::_('Normal');
		}

		// Add the attachments if they excists
		if ($result->attachments)
		{
			jimport('joomla.filesystem.folder');
			$attachments	= JFolder::files( JPATH_COMPONENT_SITE.DS.'attachments'.DS.$mid );
			$baseurl		= JURI::root().'components/com_jam/attachments/'.$mid.'/';
			foreach ($attachments as $attachment)
			{
				if ($attachment == 'index.html') {continue;}
				$array[]	= '<a href="'.$baseurl.$attachment.'" target="_blank">'.$attachment.'</a>';
			}
			$result->attachments = implode( ' - ', $array);
		}

		// Use To or From, depending on user is receiver or sender.
		// And show 'reply' action?
		if ($result->sid == $user_id)
		{
			if ($config->get('profile') && $result->user) {
				JAMLoad::_( 'librarie', 'profile', 'site' );
				$result->user = JAMProfile::getProfileLink( $ids );
			}

			$result->to_or_from = JText::_('To');
			$params[] = 'send';
			if ($result->draft) {
				$params[] = 'draft';
				$result->user = JText::_('Draft').($result->user ? ': '.$result->user : null);
				unset($result->read);
				unset($result->readt);
			}
			else if (!$result->user) {
				$result->user = JText::_('Not found');
			}
		} else
		{
			$result->to_or_from = JText::_('From');
			unset($result->read);
			unset($result->readt);
			if ($result->sid == '1') {
				$user->user	= JText::_('Information message');
			}
			else {
				if ($config->get('profile') && $result->user) {
					JAMLoad::_( 'librarie', 'profile', 'site' );
					$result->user = JAMProfile::getProfileLink( $ids );
				}
				else if (!$result->user) {
					$result->user = JText::_('Not found');
				}

				$params[] = 'send';
				$params[] = 'reply';
			}
		}

		// Remove the slashes from the message
		$result->subject = stripslashes($result->subject);
		$result->message = stripslashes($result->message);

		// Show 'Mark as new' or 'mark as read'
		if ($result->rid == $user_id) {
			$params[] = $result->state ? 'marknew' : 'markread';
		}

		// Show 'archivate' action?
		if (($result->rid == $user_id && $result->inbox != '2') || ($result->sid == $user_id && $result->outbox != '2')) {
			$params[] = 'archive';
		}

		// Show 'previous location' action?
		if (($result->rid == $user_id && $result->inbox != '1') || ($result->sid == $user_id && $result->outbox != '1')) {
			$params[] = 'previous';
		}

		// Show 'trash' or 'delete' action?
		if (($result->rid == $user_id && ($result->inbox == '1' || $result->inbox == '2')) || ($result->sid == $user_id && ($result->outbox == '1' || $result->outbox == '2'))) {
			$params[] = 'trash';
		} else {
			$params[] = 'delete';
		}

		// Add Tags
		$params['tags']	= $model->getNewTags($mid);

		// Untag
		$params['untag']=& $tags;

		// Show 'block user' action?
		if ($config->get('blocking')) {
			$blocked	= explode( ',', $usersettings->blocked);

			for ($i = 0, $t = count($ids); $i < $t; $i++)
			{
				// If the progressed users is not blocked, show the block button and stop looking
				if (in_array( $ids[$i], $blocked) === false) {
					$params[]	= 'blocking';
					$i			= $t;
				}
			}
		}

		// The id for the export links
		$params['export'] = $result->id.':'.$result->subject;

		// Actionmenu
		JAMLoad::_( 'includes', 'actionmenu', 'site' );
		$actions = JAMActionmenu::_($params);

		$this->assign( 'result',	$result);
		$this->assign( 'actions',	$actions );

		parent::display($tpl);
	}
}
?>