<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewNew extends JView
{
	function display( $tpl = null)
	{
		JAMLoad::_( 'includes', 'editor', 'site');
		JAMLoad::_( 'helper', 'new', 'site');
		$config		=& JAMConfig::getConfig();
		$user		=& JFactory::getUser();
		$gid		= $user->get('gid');

		// Get variables
		$receivers	= JRequest::getVar( 'receivers', '', 'POST');
		$subject	= JRequest::getVar( 'subject', '', '', 'STRING');
		$message	= JRequest::getVar( 'text', '', 'POST', 'STRING', JREQUEST_ALLOWRAW);
		$mid		= JRequest::getVar( 'mid', false, 'POST', 'ARRAY');
		$action		= JRequest::getVar( 'action', false, 'POST', 'STRING');
		$to			= JRequest::getVar( 'to', false);

		// Link from a third-party extension
		if ($to) {
			JAMLoad::_( 'librarie', 'receivers', 'site');
			$model =& JAMLoad::Object( 'model', 'new', 'site');

			$to = preg_replace( '@\s@', '', $to);
			$to = explode( ';', $to);

			// If the users are given by their id's, check them and convert them to (user)names
			if (is_numeric($to[0])) {
				$receivers = $model->getUsername(
								JAMReceivers::RemoveInvalidUsers($to)
							).';';
			// If the users are given by their (user)names, just check them
			} else {
				$receivers = $model->getUsername(
								JAMReceivers::getValidIds($to)
							).';';
			}
		}

		// Give the form-subject and form-message a value
		if ($action && $mid) {
			$model      =& JAMLoad::Object( 'model', 'new', 'site');
			$result		=& $model->getMessage($mid[0]);
			if ($result->sid == $user->get('id')) {
				$result->user =& $model->getUser($mid[0]);
			} else {
				$result->user =& $model->getUsername($result->sid);
			}

			// Set some vars for the new view
			if ($action == 'send') {
				JRequest::setVar( 'priority', $result->priority, 'POST');
				JRequest::setVar( 'system', $result->system, 'POST');
			}

			$data		= JAMHelperNew::getData( $action, $result );

			$receivers	= $data['receivers'];
			$subject	= $data['subject'];
			$message	= $data['message'];
		}

		// Get the editor
		$editor	= $user->getParam('editor');
		$editor	= ($editor == 'xstandard' || $editor == 'none') ? $editor : 'tinymce';
		$editor	=& new JAMEditor( $editor );

		// Receivers, subject, message
		$receivers	= JAMHtml::item(
						'To',
						'<input type="text" id="receivers" name="receivers" class="inputbox" size="50" value="'.$receivers.'" />',
						'TIP Receivers'
					);
		$subject	= JAMHtml::item(
						'Subject',
						'<input type="text" id="subject" name="subject" size="50" class="inputbox" maxlength="200" value="'.$subject.'" />'
					);
		$message	= JAMHtml::item(
						'Message',
						$editor->display( 'text', $message, '100%', '350', '70', '25', false)
					);

		// Usersearch
		$usersearch	= new StdClass();
		$usersearch->input	= '<input type="text" id="searchuser" />';
		$buttons			= array( '<input type="button" value="'.JText::_('Search').'" onclick="JAMNewUsersearch( \'&search=\' + document.getElementById(\'searchuser\').value );" />' );
		if ( $config->get('userlist_'.$gid) ) {
			$buttons[]		= '<input type="button" value="'.JText::_( 'All').'" onclick="document.getElementById(\'searchuser\').value=\'\'; JAMNewUsersearch(\'&all=1\');" />';
		}
		$usersearch->buttons= $buttons;
		$usersearch->result	= '<div id="JAMResult"></div>';

		// Options
		$items		= JAMHelperNew::items();

		// Sendbutton
		$sendbutton	= 'type="submit" id="sendbutton" value="'.JText::_('Send', true).'" onclick="'.$editor->save('text').'return JAMNewSubmit();"';

		// Attachments
		$session	=& JFactory::getSession();
		$url		= JURI::base().'index.php?option=com_jam&controller=attachment&format=raw&'.$session->getName().'='.$session->getId();

		$this->assign( 'receivers'	, $receivers);
		$this->assign( 'subject'	, $subject);
		$this->assign( 'message'	, $message);
		$this->assign( 'usersearch'	, $usersearch);
		$this->assign( 'items'		, $items);
		$this->assign( 'sendbutton'	, $sendbutton);
		$this->assign( 'attachmenturl', $url );

		parent::display($tpl);
	}
}
?>