<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewExport extends JView
{
	function display( $tpl = null)
	{
		JAMLoad::_( 'helper', 'read', 'site' );

		$document	=& JFactory::getDocument();
		$model		=& JAMLoad::Object( 'model', 'read', 'site' );
		$user		=& JFactory::getUser();
		$user_id	= $user->get( 'id');
		$usersettings=& JAMConfig::getUserSettings();
		$mid		= (int) JRequest::getVar( 'id', 0, 'GET', 'INT');

		// Get the message
		$result = $model->getMessage($mid);
		if (!isset($result->id)) {
			echo JText::_( 'ALERTNOTAUTH');
		}

		/// Get the user's ids and (user)names
		if ($result->rid == $user_id)
		{
			$config	=& JAMConfig::getConfig();
			$select	= $config->get('displayuser');
			$sender	=& JFactory::getUser($result->sid);
			if ($select == '1') {
				$sender = $sender->get('username');
			} else if ($select == '2') {
				$sender = $sender->get('name');
			} else if ($select == '3') {
				$sender = $sender->get('username').' ('.$sender->get('name').')';
			} else if ($select == '4') {
				$sender = $sender->get('name').' ('.$sender->get('username').')';
			}

			$result->user = $sender;
		}
		else 
		{
			$data	= $model->getUser($mid);
			$users	= null;
			for ($i = 0, $t = count($data), $l = $t-1; $i < $t; $i++)
			{
				$users .= $data[$i]['user'];
				if ($i < $l) {$users .= ', ';}
			}
			$result->user = $users;
		}

		// Convert the messagetime into the user's timezone and the user's date format
		$result->datetime = JHTML::Date( $result->datetime, $usersettings->dateformat, $user->getParam('timezone', '0') );

		// Convert the priority into text
		if ($result->priority == '3') {
			$result->priority = JText::_('High');
		} else if ($result->priority == '1') {
			$result->priority = JText::_('Low');
		} else {
			$result->priority = JText::_('Normal');
		}

		// Use To or From, depending on user is receiver or sender.
		// And show 'reply' action?
		if ($result->sid == $user_id)
		{
			$result->to_or_from = JText::_('To');
			if ($result->draft) {
				$result->user = JText::_('Draft').($result->user ? ': '.$result->user : null);
			}
		} else
		{
			$result->to_or_from = JText::_('From');
			if ($result->sid == '1') {
				$user->user	= JText::_('Information message');
			}
		}

		// Remove the slashes from the message
		$result->subject = stripslashes($result->subject);
		$result->message = stripslashes($result->message);

		// set document information
		$document->setTitle($result->subject);
		$document->setName($result->subject);

		// prepare header lines
		$document->setHeader( JText::_('Powered by').': '.JText::_('Joomla Advanced Message') );

		echo	'<br />'.
				'<b>'.JText::_('Sent at').'</b>: '.$result->datetime.'<br />'.
				'<b>'.JText::_('Priority').'</b>: '.$result->priority.'<br />'.
				'<b>'.$result->to_or_from.'</b>: '.$result->user.'<br />'.
				'<b>'.JText::_('Subject').'</b>: '.$result->subject.'<br /><br />'.
				$result->message;
	}
}
?>