<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewExport extends JView
{
	function display( $tpl = null)
	{
		$layout = $this->getLayout();

		if ($layout == 'print') {
			$this->_print($tpl);
			return;
		} else if ($layout == 'email') {
			$this->_email($tpl);
			return;
		}
	}

	function _print( $tpl)
	{
		JAMLoad::_( 'helper', 'read', 'site' );

		$document	=& JFactory::getDocument();
		$model		=& JAMLoad::Object( 'model', 'read', 'site' );
		$user		=& JFactory::getUser();
		$user_id	= $user->get( 'id');
		$usersettings=& JAMConfig::getUserSettings();
		$mid		= (int) JRequest::getVar( 'id', 0, 'GET', 'INT');

		// Add the script to show automaticly the print screen
		$document->addScriptDeclaration( 'window.onload=window.print();');

		// Get the message
		$result = $model->getMessage($mid);
		if (!isset($result->id)) {
			exit('<script>alert("'.JText::_( 'ALERTNOTAUTH', true).'");document.close();</script>');
		}

		// Get the user's ids and (user)names
		if ($result->rid == $user_id)
		{
			$config	=& JAMConfig::getConfig();
			$select	= $config->get('displayuser');
			$sender	=& JFactory::getUser($result->sid);
			if ($select == '1') {
				$sender = $sender->get('username');
			} else if ($select == '2') {
				$sender = $sender->get('name');
			} else if ($select == '3') {
				$sender = $sender->get('username').' ('.$sender->get('name').')';
			} else if ($select == '4') {
				$sender = $sender->get('name').' ('.$sender->get('username').')';
			}

			$result->user = $sender;
		}
		else 
		{
			$data	= $model->getUser($mid);
			$users	= null;
			for ($i = 0, $t = count($data), $l = $t-1; $i < $t; $i++)
			{
				$users .= $data[$i]['user'];
				if ($i < $l) {$users .= ', ';}
			}
			$result->user = $users;
		}

		// Convert the messagetime into the user's timezone and the user's date format
		$result->datetime = JHTML::Date( $result->datetime, $usersettings->dateformat, $user->getParam('timezone', '0') );

		// Convert the priority into text
		if ($result->priority == '3') {
			$result->priority = JText::_('High');
		} else if ($result->priority == '1') {
			$result->priority = JText::_('Low');
		} else {
			$result->priority = JText::_('Normal');
		}

		// Use To or From, depending on user is receiver or sender.
		// And show 'reply' action?
		if ($result->sid == $user_id)
		{
			$result->to_or_from = JText::_('To');
			if ($result->draft) {
				$result->user = JText::_('Draft').($result->user ? ': '.$result->user : null);
			}
		} else
		{
			$result->to_or_from = JText::_('From');
			if ($result->sid == '1') {
				$user->user	= JText::_('Information message');
			}
		}

		// Remove the slashes from the message
		$result->subject = stripslashes($result->subject);
		$result->message = stripslashes($result->message);

		$this->assign('result', $result);

		parent::display($tpl);
	}

	function _email( $tpl)
	{
		$this->template->_('initialize');

		// Check if the user is allowed to send this message
		$mid		= (int) JRequest::getVar( 'id', 0, 'GET', 'INT');
		$model		=& JAMLoad::Object( 'model', 'read', 'site' );
		$result		= $model->getMessage($mid);
		if (!isset($result->id)) {
			exit('<script>alert("'.JText::_( 'ALERTNOTAUTH', true).'");document.close();</script>');
		}

		$user		=& JFactory::getUser();
		$email		= $user->get('email').';';

		$this->assign( 'email',	$email);
		$this->assign( 'id',	$result->id);

		parent::display($tpl);
	}
}
?>