<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

/**
 * @param	array
 * @return	array
 */
function JAMBuildRoute( &$query )
{
	$segments = array();

	// View
	if(isset( $query['view'] )) {
		$segments[] = $query['view'];
		unset($query['view']);
	};

	// Layout
	if (isset( $query['layout'] )) {
		$segments[] = $query['layout'];
		unset( $query['layout'] );
	};

	// Message
	if (isset( $query['id'] )) {
		$segments[] = $query['id'];
		unset( $query['id'] );
	};

	// Tmpl
	if (isset( $query['tmpl'] )) {
		$segments[] = 't:'.$query['tmpl'];
		unset( $query['tmpl'] );
	};

	// Controller
	if (isset( $query['controller'] )) {
		$segments[] = 'c:'.$query['controller'];
		unset( $query['controller'] );
	};

	return $segments;
}

/**
 * @param	array
 * @return	array
 */
function JAMParseRoute( $segments )
{
	$vars = array();

	if (isset($_POST['option']) && $_POST['option'] == 'com_jam') {
		return $vars;
	}

	// View
	$vars['view'] = $segments[0];
	unset( $segments[0] );

	/*
	 * Special view depending vars
	 */
	if ($vars['view'] == 'export')
	{
		// Layout and / or Message
		$var = explode( ':', $segments[1] );
		if (is_numeric( $var[0] )) {
			$vars['id'] = $var[0];
		} else {
			$vars['layout'] = $var[0];
			$vars['id'] = $segments[2];
			unset( $segments[2] );
		}
		unset( $segments[1] );
	}
	else if ($vars['view'] == 'new')
	{
		// To (receivers)
		if (isset( $segments[1] )) {
			$vars['to'] = $segments[1];
			unset( $segments[1] );
		}
		// Subject
		if (isset( $segments[2] )) {
			$vars['subject'] = $segments[2];
			unset( $segments[2] );
		}
	}
	else if ($vars['view'] == 'read')
	{
		// Message
		$vars['id'] = $segments[1];
		unset( $segments[1] );
	}	

	// Check all remaining segments
	foreach ($segments as $segment)
	{
		$var = explode( ':', $segment );
		if ($var[0] == 't') {
			$vars['tmpl'] = $var[1];
		} else if ($var[0] == 'c') {
			$vars['controller'] = $var[1];
		}
	}

	return $vars;
}