<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT.DS.'models'.DS.'model.php' );

class JAMModelUsersearch extends JAMModel
{
	function __construct()
	{
		JAMLoad::_( 'librarie', 'receivers', 'site' );
		
		parent::__construct();
	}

	/**
	 * Count Messages
	 *
	 * @parram array	$where. Contains the WHERE parts (without 'WHERE')
	 * @access			public
	 * @return			int
	 */
	function countUsernames($search)
	{
		$db		=& $this->db;
		$hidden	= JAMReceivers::SQLHiddenUsers();

		// Search or all users?
		if ($search) {
			$search = $this->_wherepart( $search );
			$query	= 'SELECT COUNT(u.id)'
					. ' FROM `#__users` AS u'
					. ' WHERE '.$search.' AND '.$hidden.' AND u.block = 0';
		} else {
			$query	= 'SELECT COUNT(u.id)'
					. ' FROM `#__users` AS u'
					. ' WHERE '.$hidden.' AND u.block = 0';
		}
		$db->setQuery($query);
		$result	= $db->loadResult();

		return $result;
	}

	/**
	 * Get all usernames except the user and the hidden ones
	 *
	 * @parram string	$search. Contains the string of the user who is searched
	 * @parram int		$limitstart. Contains the amount the start the list from
	 * @parram int		$limit. Contains the total amount of the max results
	 * @access			public
	 * @return			array
	 */
	function SearchUsernames($search, $limitstart, $limit)
	{
		$db		=& $this->db;
		$select	= JAMUsers::SQLUserLong();
		$order	= JAMUsers::SQLUserShort();
		$hidden	= JAMReceivers::SQLHiddenUsers();

		if ($search) {
			$search = $this->_wherepart();
			$query	= 'SELECT '.$select
					. ' FROM `#__users` AS u'
					. ' WHERE '.$search.' AND '.$hidden.' AND u.block = 0'
					. ' ORDER BY '.$order.' ASC';
		} else {
			$query	= 'SELECT '.$select
					. ' FROM `#__users` AS u'
					. ' WHERE '.$hidden.' AND u.block = 0'
					. ' ORDER BY '.$order.' ASC';
		}

		$db->setQuery($query, $limitstart, $limit);
		$result	= $db->loadResultArray();

		return $result;
	}

	/**
	 * ?
	 *
	 * @parram array	$string. Contains a search string
	 * @access			private
	 * @return			string
	 */
	function _wherepart($search = '')
	{
		static $string;

		if (!$string) {
			$config	=& JAMConfig::getConfig();
			$display= $config->get( 'displayuser');
			$array	= explode( ' ', $search);
			$parts	= array();
			
			for ($i = 0, $t = count($array); $i < $t; $i++)
			{
				$part = $array[$i];

				if ($display == '3' || $display == '4') {
					$parts[] = "(u.username LIKE '%$part%' OR u.name LIKE '%$part%')";
				} else {
					$parts[] = '('.JAMUsers::SQLUserShort()." LIKE '%$part%')";
				}
			}

			$string	= implode( ' AND ', $parts);
		}

		return $string;
	}
}