<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT.DS.'models'.DS.'model.php' );

class JAMModelRead extends JAMModel
{
	/**
	 * Get a message
	 *
	 * @parram int	$id. Contains the message-id
	 * @access		public
	 * @return		object
	 */
	function &getMessage($id)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$query	= 'SELECT m.*, r.rid, r.inbox, r.state,'
				. ' SUM(r.state) AS `read`, COUNT(r.id) AS readt'
				. ' FROM `#__jam` AS m'
				. ' LEFT JOIN `#__jam_receivers` AS r ON r.mid = m.id'
				. ' WHERE m.id = '.$id.' AND ((r.rid = '.$user_id.' AND r.inbox != 0 AND draft = 0) OR (m.sid = '.$user_id.' AND m.outbox != 0))'
				. ' GROUP BY m.id';
		$db->setQuery($query);
		$result	= $db->loadObject();

		return $result;
	}

	/**
	 * Get user(s) info
	 *
	 * @parram int	$id. Contains the message-id
	 * @acces		public
	 * @return		array
	 */
	function getUser($id)
	{
		$db		=& JFactory::getDBO();

		$query	= 'SELECT u.id, '.JAMUsers::SQLUserLong().' AS user'
				. ' FROM `#__jam_receivers` AS r'
				. ' LEFT JOIN `#__users` AS u ON u.id = r.rid'
				. ' WHERE r.mid = '.$id
				. ' ORDER BY '.JAMUsers::SQLUserShort().' ASC';
		$db->setQuery($query);
		$result = $db->loadAssocList();

		return $result;
	}

	/**
	 * Set the message to read
	 *
	 * @parram int		$id. Contains the message-id
	 * @access			public
	 * @return			mixed
	 */
	function SetRead($id)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$query	= 'UPDATE `#__jam_receivers` SET state = \'1\' WHERE mid = '.$id.' AND rid = '.$user_id;
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		return true;
	}

	/**
	 * Get all tags, not used by the message
	 *
	 * @param		int		$mid. The message-id
	 * @access		public
	 * @return		array
	 */
	function getNewTags($mid)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$query	= 'SELECT tag FROM `#__jam_tags`'
				. ' WHERE uid = '.$user_id.' AND NOT FIND_IN_SET('.$mid.',mids)'
				. ' ORDER BY tag ASC';
		$db->setQuery($query);
		$result	= $db->loadResultArray();

		return $result;
	}

	/**
	 * Get all tags used by the message
	 *
	 * @param		int		$mid. The message-id
	 * @access		public
	 * @return		object
	 */
	function &getTagsByMessage($mid)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$query	= 'SELECT id, tag FROM `#__jam_tags`'
				. ' WHERE uid = '.$user_id.' AND FIND_IN_SET('.$mid.',mids)'
				. ' ORDER BY tag ASC';
		$db->setQuery($query);
		$result	= $db->loadObjectList();

		return $result;
	}
}