<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT_SITE.DS.'models'.DS.'box.php' );

class JAMModelOutbox extends JAMModelBox
{
	/**
	 * Count Messages
	 *
	 * @parram array	$where. Contains the WHERE parts
	 * @access			public
	 * @return			int
	 */
	function countMessages($where)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$where	= $where ? ' AND '.implode( ' AND ', $where) : '';

		$query	= 'SELECT COUNT(DISTINCT m.id)'
				. ' FROM `#__jam` AS m'
				. ($where ? 
					' LEFT JOIN `#__jam_receivers` AS r ON r.mid = m.id'
					. ' LEFT JOIN `#__users` AS u ON u.id = r.rid'
					: null)
				. ' WHERE m.sid = '.$user_id.' AND m.outbox = 1'
				. $where;
		$db->setQuery($query);
		return $db->loadResult();
	}

	/**
	 * Get messages
	 *
	 * @parram array	$where. Contains WHERE parts
	 * @parram string	$order. Contains the order string
	 * @parram int		$limitstart. Contains the number to start
	 * @parram int		$limit. Contains the number to end
	 * @access			public
	 * @return			object
	 */
	function &getMessages($where, $order, $limitstart, $limit)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$where	= $where ? ' AND '.implode( ' AND ', $where) : '';

		$query	= 'SELECT m.id, m.sid, m.subject, LEFT(m.message,100) AS message, m.datetime, m.priority, m.draft, m.system, m.attachments,'
				. ' GROUP_CONCAT('.JAMUsers::SQLUserLong().' ORDER BY '.JAMUsers::SQLUserShort().' SEPARATOR \', \') AS user,'
				. ' SUM(r.state) AS `read`, COUNT(u.id) AS readt'
				. ' FROM `#__jam` AS m'
				. ' LEFT JOIN `#__jam_receivers` AS r ON r.mid = m.id'
				. ' LEFT JOIN `#__users` AS u ON u.id = r.rid'
				. ' WHERE m.sid = '.$user_id.' AND m.outbox = 1'
				. $where
				. ' GROUP BY m.id'
				. ' ORDER BY '.$order;
		$db->setQuery($query, $limitstart, $limit);
		$result	= $db->loadObjectList();

		return $result;
	}
}