<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT.DS.'models'.DS.'model.php' );

class JAMModelNew extends JAMModel
{
	/**
	 * Get username(s)
	 *
	 * @parram mixed	$ids. The id(s) of the user(s) to get his/their username.
	 * @acces			public
	 * @return			string
	 */
	function getUsername($ids)
	{
		$db		=& JFactory::getDBO();
		if (is_array($ids)) {
		 	$ids = implode(',', $ids);
		}

		$query	= 'SELECT '.JAMUsers::SQLUserLong()
				.' FROM `#__users` AS u'
				.' WHERE u.id IN ('.$ids.')'
				.' ORDER BY '.JAMUsers::SQLUserShort().' ASC';
		$db->setQuery($query);
		$result = $db->loadResultArray();

		return implode('; ', $result);
	}

	/**
	 * Get a message
	 *
	 * @parram int	$id. Contains the message-id
	 * @access		public
	 * @return		object
	 */
	function &getMessage($id)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$query	= 'SELECT m.sid, m.subject, m.message, m.datetime, m.priority, m.system'
				. ' FROM `#__jam` AS m'
				. ' WHERE m.id = '.$id;
		$db->setQuery($query);
		$result	= $db->loadObject();

		return $result;
	}

	/**
	 * Get user(s) info
	 *
	 * @parram int	$id. Contains the message-id
	 * @acces		public
	 * @return		array
	 */
	function getUser($id)
	{
		$db		=& JFactory::getDBO();

		$query	= 'SELECT '.JAMUsers::SQLUserLong().' AS user'
				. ' FROM `#__jam_receivers` AS r'
				. ' LEFT JOIN `#__users` AS u ON u.id = r.rid'
				. ' WHERE r.mid = '.$id
				. ' ORDER BY '.JAMUsers::SQLUserShort().' ASC';
		$db->setQuery($query);
		$result = $db->loadResultArray();

		return implode('; ', $result);
	}
}