<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Load the general model
require_once( JPATH_COMPONENT_SITE.DS.'models'.DS.'box.php' );

class JAMModelInbox extends JAMModelBox
{
	/**
	 * Count Messages
	 *
	 * @parram array	$where. Contains the WHERE parts
	 * @access			public
	 * @return			int
	 */
	function countMessages($where)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$where	= $where ? ' AND '.implode( ' AND ', $where) : '';

		$query	= 'SELECT COUNT(r.id)'
				. ' FROM `#__jam_receivers` AS r'
				. ($where ? 
					' LEFT JOIN `#__jam` AS m ON m.id = r.mid'
					. ' LEFT JOIN `#__users` AS u ON u.id = m.sid'
					: null)
				. ' WHERE r.rid = '.$user_id.' AND r.inbox = 1'
				. $where;
		$db->setQuery($query);
		return $db->loadResult();
	}

	/**
	 * Get messages
	 *
	 * @parram array	$where. Contains WHERE parts
	 * @parram string	$order. Contains the order string
	 * @parram int		$limitstart. Contains the number to start
	 * @parram int		$limit. Contains the number to end
	 * @access			public
	 * @return			object
	 */
	function &getMessages($where, $order, $limitstart, $limit)
	{
		$db		=& $this->db;
		$user_id= $this->user->get('id');

		$where	= $where ? ' AND '.implode( ' AND ', $where) : '';

		$query	= 'SELECT r.state, m.id, m.sid, m.subject, LEFT(m.message,100) AS message,'
				. ' m.datetime, m.priority, m.system, m.attachments, '.JAMUsers::SQLUserLong().' AS user'
				. ' FROM `#__jam_receivers` AS r'
				. ' LEFT JOIN `#__jam` AS m ON m.id = r.mid'
				. ' LEFT JOIN `#__users` AS u ON u.id = m.sid'
				. ' WHERE r.rid = '.$user_id.' AND r.inbox = 1'
				. $where
				. ' ORDER BY '.$order;
		$db->setQuery($query, $limitstart, $limit);
		$result	= $db->loadObjectList();

		return $result;
	}
}