<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMReceivers
{
	/**
	 * Get valid userids
	 *
	 * @parram array	$users. The user's name or username to get their id
	 * @access			public
	 * @return			array
	 */
	function getValidIds($users)
	{
		$db		=& JFactory::getDBO();
		$users	= implode( "','", $users);
		$select	= JAMUsers::SQLUserShort();
		$hidden	= JAMReceivers::SQLHiddenUsers();

		$query	= 'SELECT u.id'
				. ' FROM `#__users` AS u'
				. ' WHERE '.$select.' IN (\''.$users.'\') AND '.$hidden.' AND u.block = 0';
		$db->setQuery($query);
		$ids = $db->loadResultArray();

		return $ids;
	}

	/**
	 * Get valid users from group(s)
	 *
	 * @parram array	$ids. The id(s) of the groups(s)
	 * @acces			public
	 * @return			array
	 */
	function getValidIdsFromGroup($ids)
	{
		$db		=& JFactory::getDBO();
		$ids	= implode( ',', $ids);
		$hidden	= JAMReceivers::SQLHiddenUsers();

		$query	= 'SELECT u.id'
				. ' FROM `#__users` AS u'
				. ' WHERE u.gid IN ('.$ids.') AND '.$hidden.' AND u.block = 0';
		$db->setQuery($query);
		$result	= $db->loadResultArray();

		return $result;
	}

	/**
	 * Get all user ids, except the active user and the hidden ones
	 *
	 * @access			public
	 * @return			array
	 */
	function getAllValidUsers()
	{
		$db		=& JFactory::getDBO();
		$hidden	= JAMReceivers::SQLHiddenUsers();

		$query	= 'SELECT u.id'
				. ' FROM `#__users` AS u'
				. ' WHERE '.$hidden.' AND u.block = 0';
		$db->setQuery($query);
		$result	= $db->loadResultArray();

		return $result;
	}

	/**
	 * Removes the invalid users
	 *
	 * @parram array	$ids. Contains the ids who has to be checked
	 * @access			public
	 * @return			array
	 */
	function RemoveInvalidUsers($ids)
	{
		$valid = JAMReceivers::getAllValidUsers();

		for ($i = 0, $n = count($ids); $i < $n; $i++)
		{
			if (!in_array( $ids[$i], $valid)) {
				unset( $ids[$i] );
			}
		}
		sort($ids);

		return $ids;
	}

	/**
	 * Returns the sql string for hidden (denied) users
	 *
	 * @access			public
	 * @return			string
	 */
	function SQLHiddenUsers()
	{
		static $string;

		if (!$string)
		{
			$config		=& JAMConfig::getConfig();
			$user		=& JFactory::getUser();
			$user_name	= $user->get( 'username');

			$hidden		= $user_name;
			if ($users = $config->get( 'hideusers')) {
				$hidden .= "','".implode( "','", 
							explode( ',', $users )
						);
			}

			$string = "u.username NOT IN ('$hidden')";
		}

		return $string;
	}
}
?>