<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMProfile
{
	/**
	 * Get profile links with images
	 *
	 * @param mixed		$ids. Contains the user-id(s)
	 * @access			public
	 * @return			string
	 */
	function getProfileLink($ids)
	{
		$db			=& JFactory::getDBO();
		$config		=& JAMConfig::getConfig();
		$profile	= $config->get('profile');
		$array		= array();

		if (is_array($ids)) {
			$ids = implode( ',', $ids);
		}

		if ($profile == 'communitybuilder')
		{
			$base_url		= JURI::root().'index.php?option=com_comprofiler&task=userprofile&user=';
			$base_image		= JURI::root().'images/comprofiler/';
			$base_noimage	= JURI::root().'components/com_comprofiler/plugin/language/default_language/images/nophoto.jpg';

			$query			= 'SELECT cb.user_id AS uid, cb.avatar AS image, '.JAMUsers::SQLUserLong().' AS user'
							. ' FROM `#__comprofiler` AS cb'
							. ' LEFT JOIN `#__users` AS u ON u.id = cb.user_id'
							. ' WHERE cb.user_id IN ('.$ids.')'
							. ' ORDER BY '.JAMUsers::SQLUserShort().' ASC';
			$db->setQuery($query);
			$result = $db->loadObjectList();
		}
		else if ($profile == 'fireboard')
		{
			$base_url		= JURI::root().'index.php?option=com_fireboard&func=fbprofile&task=showprf&userid=';
			$base_image		= JURI::root().'images/fbfiles/avatars/';
			$base_noimage	= JURI::root().'images/fbfiles/avatars/s_nophoto.jpg';

			$query			= 'SELECT fb.userid AS uid, fb.avatar AS image, '.JAMUsers::SQLUserLong().' AS user'
							. ' FROM `#__fb_users` AS fb'
							. ' LEFT JOIN `#__users` AS u ON u.id = fb.userid'
							. ' WHERE fb.userid IN ('.$ids.')'
							. ' ORDER BY '.JAMUsers::SQLUserShort().' ASC';
			$db->setQuery($query);
			$result = $db->loadObjectList();
		}

		for ($i = 0, $t = count($result); $i < $t; $i++)
		{
			$item		= $result[$i];
			$link		= JRoute::_( $base_url.$item->uid );
			$scr		= $item->image ? $base_image.$item->image : $base_noimage;

			$array[]	= '<a id="l'.$i.'" href="'.$link.'">'.$item->user.'</a> '
						. ' <img id="i'.$i.'" src="'.$scr.'" />';
		}

		$string = '<div id="jam-profile">'.implode(', ', $array).'</div>';
		return $string;
	}
}
?>