<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMMessages
{
	/**
	 * Writes a message
	 *
	 * @parram array	$receivers. Contains the id(s) of the receiver(s)
	 * @parram string	$subject. Contains the subject
	 * @parram string	$message. Contains the message
	 * @parram string	$datetime. Contains the date and the time in mysql format
	 * @parram array	$options. Contains the options data (optional)
	 * @access			public
	 * @return			mixed
	 */
	function Write( $receivers, $subject, $message, $datetime, $options = array() )
	{
		$db			=& JFactory::getDBO();
		$config		=& JAMConfig::getConfig();
		$user		=& JFactory::getUser();
		$sid		= $user->get('id');

		// Message options
		if ($options)
		{
			$priority	= isset( $options['priority'] )		? $options['priority']		: '2';
			$system		= isset( $options['system'] )		? $options['system']		: '0';
			$attachments= isset( $options['attachments'] )	? $options['attachments']	: '0';
			if ( isset($options['information']) && $options['information'] ) {$sid = '1';}
		}
		else {
			$priority	= '2';
			$system		= '0';
			$attachments= '0';
		}

		// Insert the message into the database
		$query = "INSERT INTO `#__jam` VALUES ( '', '$sid', '1', '$subject', '$message', '$datetime', '0', '$priority', '$system', '$attachments');";
		$db->setQuery( $query );
		if (!$db->query()) {
			return $db->stderr();
		}

		// Get the message id of the inserted message
		$mid = $db->insertid();

		// Add the attachments to the message if neccessary
		if ($attachments)
		{
			JAMLoad::_( 'librarie', 'files', 'site');
			JAMFiles::Attachments($mid);
		}

		// Insert the receivers into the database
		$chunks = array_chunk($receivers, 1000);
		for ($c = 0, $tc = count($chunks); $c < $tc; $c++)
		{
			$t		= (($c+1) < $tc) ? 1000 : count($chunks[$c]);
			
			// Build the query-part with the insert-values
			$values = array();
			for ($i = 0; $i < $t; $i++) {
				$values[] = "('', '$mid', '".$chunks[$c][$i]."', '1', '0')";
			}
			
			// Insert the messages into the database
			$values = implode( ',', $values);
			$db->setQuery( 'INSERT INTO `#__jam_receivers` VALUES '.$values);
			if (!$db->query()) {
				return $db->stderr();
			}
		}

		// Everything seems ok
		return true;
	}

	/**
	 * Saves the message as draft
	 *
	 * @parram array	$receivers. Contains the id(s) of the receiver(s)
	 * @parram string	$subject. Contains the subject
	 * @parram string	$message. Contains the message
	 * @parram string	$datetime. Contains the date and the time in mysql format
	 * @parram array	$options. Contains the options data (optional)
	 * @access			public
	 * @return			mixed
	 */
	function Draft( $receivers, $subject, $message, $datetime, $options = array() )
	{
		$db			=& JFactory::getDBO();
		$config		=& JAMConfig::getConfig();
		$user		=& JFactory::getUser();
		$sid		= $user->get('id');

		// Message options
		if ($options)
		{
			$priority	= isset( $options['priority'] )	? $options['priority']	: '2';
			$system		= isset( $options['system'] )	? $options['system']	: '0';
		}
		else {
			$priority	= '2';
			$system		= '0';
		}

		// Insert the message into the database
		$query = "INSERT INTO `#__jam` VALUES ( '', '$sid', '1', '$subject', '$message', '$datetime', '1', '$priority', '$system', '0');";
		$db->setQuery( $query );
		if (!$db->query()) {
			return $db->stderr();
		}

		// Get the message id of the inserted message
		$mid = $db->insertid();

		// Insert the receivers into the database
		$chunks = array_chunk($receivers, 1000);
		for ($c = 0, $tc = count($chunks); $c < $tc; $c++)
		{
			$t		= (($c+1) < $tc) ? 1000 : count($chunks[$c]);
			
			// Build the query-part with the insert-values
			$values = array();
			for ($i = 0; $i < $t; $i++) {
				$values[] = "('', '$mid', '".$chunks[$c][$i]."', '', '0')";
			}
			
			// Insert the messages into the database
			$values = implode( ',', $values);
			$db->setQuery( 'INSERT INTO `#__jam_receivers` VALUES '.$values);
			if (!$db->query()) {
				return $db->stderr();
			}
		}

		// Everything seems ok
		return true;
	}
}
?>