<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMLoad
{
	/**
	 * General load function
	 *
	 * @parram	string	$type. The type of the file to load.
	 * @parram	string	$filePath. The file path. (Without the .php extension)
	 * @parram	string	$site. The location of the file. (optional)
	 * @access	public
	 * return	boolean
	 */
	function _($type, $filePath, $site = '')
	{
		static $classes;

		if (!isset($classes)) {
			$classes = array();
		}

		$signature = $site.$type.$filePath;

		if (!isset( $classes[$signature] ))
		{
			// Site
			if ($site == 'site') {
				$path = JPATH_SITE.DS.'components'.DS.'com_jam'.DS;
			} else if ($site == 'admin') {
				$path = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_jam'.DS;
			} else {
				$path = JPATH_BASE.DS.'components'.DS.'com_jam'.DS;
			}

			// Type
			if ($type == 'librarie') {
				$path .= 'libraries'.DS;
			} else if ($type == 'includes') {
				$path .= 'includes'.DS;
			} else if ($type == 'model') {
				$path .= 'models'.DS;
			} else if ($type == 'helper') {
				$path .= 'helpers'.DS;
			} else {
				return false;
			}

			// File
			if ($filePath) {
				$path .= str_replace( '.', DS, $filePath ). '.php';
			} else {
				return false;
			}

			// Check if file exists
			if (!is_file($path)) {
				JError::raiseError( 500, 'The following file was supposed to be loaded, but does not exists: '.$path);
			}

			// Load the file
			require_once( $path );

			// Add the class as processed
			$classes[$signature] = 1;
		}

		return true;
	}

	/**
	 * Returns an object
	 *
	 * @parram	string	$type. The type of the file to load.
	 * @parram	string	$filePath. The file path. (Without the .php extension)
	 * @parram	string	$site. The location of the file. (optional)
	 * @access	public
	 * return	object
	 */
	function &Object($type, $filePath, $site = '')
	{
		JAMLoad::_($type, $filePath, $site);

		// Get the class name
		if ($type == 'model') {
			$class = 'JAMModel';
		} else if ($type == 'helper') {
			$class = 'JAMHelper';
		} else {
			$class = 'JAM';
		}
		$class .= array_pop(explode( '.', $filePath ));

		$object	=& new $class();
		return $object;
	}
}

// Register some files to be loaded
JLoader::register( 'JAMConfig',		JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'libraries'.DS.'config.php' );
JLoader::register( 'JAMHtml',		JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'libraries'.DS.'html.php' );
JLoader::register( 'JAMTemplate',	JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'includes'.DS.'template.php' );
JLoader::register( 'JAMUsers',		JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'includes'.DS.'users.php' );
?>