<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHtml
{
	/**
	 * Creates an item object
	 *
	 * param	string	$name. The item's name
	 * param	string	$link. The item's link
	 * param	mixed	$tip. If value: the tip string
	 * @access	public
	 * @return	object
	 */
	function item( $name, $data, $tip = false )
	{
		$item			= new StdClass();
		$item->name		= JText::_($name);
		$item->data		= $data;
		$item->tip		= $tip ? JText::_($tip) : false;
		return $item;
	}

	/**
	 * Creates an link object
	 *
	 * param	string	$name. The item's name
	 * param	mixed	$link. The item's link
	 * param	boolean	$external. If true the link is not an AJAX request
	 * @access	public
	 * @return	object
	 */
	function link( $name, $link = false, $external = false )
	{
		$item			= new StdClass();
		$item->name		= $name;
		$item->link		= $link;
		$item->external = $external;
		return $item;
	}

	/**
	 * JAM's main menu items
	 *
	 * $param	string	$active. The active view
	 * @acces	public
	 * @return	array
	 */
	function Mainmenu($active)
	{
		$views	= array( 'new', 'inbox', 'outbox', 'archive', 'trash', 'settings');
		$items	= array();

		for ($i = 0; $i < 6; $i++)
		{
			$item			= JAMHtml::link(
								$views[$i],
								'href="#'.$views[$i].'" onclick="JAMRedirect(\''.$views[$i].'\');"'
							);
			$item->active	= $active == $views[$i] ? true : false;
			$items[]		= $item;
		}

		return $items;
	}
}
?>