<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMFiles
{
	/**
	 * Move an uploaded file to a temporary folder (Upload it to JAM)
	 *
	 * @parram array	$file
	 * @access			public
	 * @return			boolean
	 */
	function Upload($file)
	{
		jimport('joomla.filesystem.file');

		// Make sure that file uploads are enabled in php
		if (!(bool) ini_get('file_uploads')) {
			return false;
		}

		// Upload the file
		$user =& JFactory::getUser();
		$username = strtolower($user->get('username'));
		$path = JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'attachments'.DS.$username.DS;
		if (!JFile::upload( $file['tmp_name'], $path.strtolower($file['name']) )) {
			return false;
		}

		// Tell JAM attachments exists
		global $mainframe;
		$mainframe->setUserState( 'attachments', 1);

		return true;
	}

	/**
	 * Rename a attachments-folder for a message
	 *
	 * @parram int	$mid
	 * @access		public
	 * @return		boolean
	 */
	function Attachments($mid)
	{
		jimport('joomla.filesystem.folder');
		jimport('joomla.filesystem.file');

		// Rename the temporary folder
		$user =& JFactory::getUser();
		$username = strtolower($user->get('username'));
		if ( !JFolder::move( $username, $mid, JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'attachments') ) {
			return false;
		}

		// Add a security index.html file
		if ( !JFile::copy( 'index.html', $mid.DS.'index.html', JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'attachments') ) {
			return false;
		}

		// Tell JAM no attachments exists
		global $mainframe;
		$mainframe->setUserState( 'attachments', 0);

		return true;
	}

	/**
	 * Remove the temporary attachments-folder
	 *
	 * @access			public
	 * @return			boolean
	 */
	function RemoveUpload()
	{
		jimport('joomla.filesystem.folder');

		// Remove the folder
		$user =& JFactory::getUser();
		$username = strtolower($user->get('username'));
		$path = JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'attachments'.DS.$username;
		if ( !JFolder::delete($path) ) {
			return false;
		}
		
		// Tell JAM no attachments exists
		global $mainframe;
		$mainframe->setUserState( 'attachments', 0);

		return true;
	}
}
?>