<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMEmail
{
	/**
	 * Alert users when they have received a new message
	 *
	 * @parram array	$receivers. Contains the receivers info
	 *					(user, email, language, includemessage)
	 * @parram string	$subject. Contains the subject
	 * @parram string	$message. Contains the message (optional)
	 * @parram array	$options. Contains the message options (optional)
	 * @access			public
	 * @return			boolean
	 */
	function EmailAlert($receivers, $subject, $message = '', $options = array() )
	{
		if (isset($options['information']) && $options['information']) {
			$sender = JText::_('Information message');
		} else {
			$config	=& JAMConfig::getConfig();
			$select	= $config->get('displayuser');
			$user	=& JFactory::getUser();
			if ($select == '1') {
				$sender = $user->get('username');
			} else if ($select == '2') {
				$sender = $user->get('name');
			} else if ($select == '3') {
				$sender = $user->get('username').' ('.$user->get('name').')';
			} else if ($select == '4') {
				$sender = $user->get('name').' ('.$user->get('username').')';
			}
		}

		// Clean some email data
		$subject	= preg_replace("/((From:|To:|Cc:|Bcc:|Content-type:) ([\S]+))/", '', $subject);
		$message	= preg_replace("/((From:|To:|Cc:|Bcc:|Subject:|Content-type:) ([\S]+))/", '', $message);

		// Send the email(s)
		if (count($receivers) < 10)
		{		
			return JAMEmail::_notification($receivers, $subject, $message, $sender);
		}
		else
		{
			$array	= array();
			for ($i = 0, $n = count($receivers); $i < $n; $i++) {
				$array[] = $receivers[$i]['email'];
			}
			return JAMEmail::_massnotification($array, $subject, $message, $sender);
		}
	}

	/**
	 * Email a message
	 *
	 * @parram array	$receivers. Contains the email of the receivers
	 * @parram string	$subject. Contains the subject
	 * @parram string	$message. Contains the message
	 * @access			public
	 * @return			boolean
	 */
	function EmailMessage($receivers, $subject, $message)
	{
		$config		=& JAMConfig::getConfig();
		$select		= $config->get('displayuser');
		$user		=& JFactory::getUser();

		// Some data for the email
		$from		= JApplication::getCfg( 'mailfrom');
		if ($select == '1') {
			$sender = $user->get('username');
		} else if ($select == '2') {
			$sender = $user->get('name');
		} else if ($select == '3') {
			$sender = $user->get('username').' ('.$user->get('name').')';
		} else if ($select == '4') {
			$sender = $user->get('name').' ('.$user->get('username').')';
		}
		$subject	= preg_replace("/((From:|To:|Cc:|Bcc:|Content-type:) ([\S]+))/", '', $subject);
		$message	= preg_replace("/((From:|To:|Cc:|Bcc:|Subject:|Content-type:) ([\S]+))/", '', $message);

		// Load the site default language
		$language = JLanguage::getInstance( JApplication::getCfg( 'language') );
		$language->load( 'joomla', JPATH_SITE);
		$language->load( 'com_jam', JPATH_SITE);

		// Add the powered by line
		$message	.= '<br /><br />--------------------<br />'
					. $language->_('Powered by').': '.$language->_('Joomla Advanced Message')
					. '<br />'.$language->_('Please do not respond to this message as it was automaticly generated.');

		for ($i = 0, $t = count($receivers); $i < $t; $i++)
		{
			if ( JUtility::sendMail($from, $sender, $receivers[$i], $subject, $message, 1) !== true) {
				return false;
			}
		}

		return true;
	}

	function _notification($receivers, $subject, $message, $sender)
	{
		$languages	= array();
		$from		= JApplication::getCfg('mailfrom');
		$defaultlang= JApplication::getCfg('language');
		$baseurl	= JURI::root();
		$website	= JApplication::getCfg('sitename');

		for ($i = 0, $n = count($receivers); $i < $n; $i++)
		{
			$receiver	 = $receivers[$i];

			// Get the receivers language
			$lang		= isset($receiver['language']) ? $receiver['language'] : $defaultlang;
			if ( !isset($languages[$lang]) ) {
				$language			= JLanguage::getInstance($lang);
				$language->load( 'joomla', JPATH_SITE);
				$language->load( 'com_jam', JPATH_SITE);
				$languages[$lang]	= $language;
			}
			$language	= $languages[$lang];

			// E-mail subject
			$mail_sub	= sprintf( $language->_('New message: %s'), $subject );

			// E-mail body
			$mail_body	= sprintf( $language->_('Hello %s'), $receiver['user'] ).",<br /><br />\n"
						. sprintf( $language->_('You have received a message from %s'), $sender ).".<br />\n";

			// Include the message or give the website link
			if ($message && isset($receiver['includemessage']) && $receiver['includemessage'])
			{
				$mail_body	.= $language->_('The message is included below').":<br /><br />\n"
							. '<b>'.$language->_('From')	.'</b>: '.$sender."<br />\n"
							. '<b>'.$language->_('Subject')	.'</b>: '.$subject."<br /><br />\n"
							. $message."\n";
			} else
			{
				$mail_body .= $language->_('You may read the message on the website').': <a href="'.$baseurl.'" target="_blank">'.$website."</a>\n";
			}

			// Add the powered by line
			$mail_body	.= '<br /><br />--------------------<br />'
						. $language->_('Powered by').': '.$language->_('Joomla Advanced Message')
						. '<br />'.$language->_('MAIL_MSG');

			if ( JUtility::sendMail($from, $sender, $receiver['email'], $mail_sub, $mail_body, 1) !== true) {
				return false;
			}
		}

		return true;
	}

	function _massnotification($receivers, $subject, $message, $sender)
	{
		$config		=& JAMConfig::getConfig();
		$from		= JApplication::getCfg('mailfrom');
		$baseurl	= JURI::root();
		$website	= JApplication::getCfg('sitename');
		
		// E-mail subject
		$mail_sub	= JText::sprintf( 'New message: %s', $subject );

		// E-mail body
		$mail_body	= JText::sprintf('Hello %s', JText::_('User')).",<br /><br />\n"
					. JText::sprintf( 'You have received a message from %s', $sender ).".<br />\n";

		// Include the message or give the website link
		if ($message && $config->get('notification_message'))
		{
				$mail_body	.= JText::_('The message is included below').":<br /><br />\n"
							. '<b>'.JText::_('From')	.'</b>: '.$sender."<br />\n"
							. '<b>'.JText::_('Subject')	.'</b>: '.$subject."<br /><br />\n"
							. $message."\n";
		} else
		{
			$mail_body .= JText::_('You may read the message on the website').': <a href="'.$baseurl.'" target="_blank">'.$website."</a>\n";
		}

		// Add the powered by line
		$mail_body	.= '<br /><br />--------------------<br />'
					. JText::_('Powered by').': '.JText::_('Joomla Advanced Message')
					. '<br />'.JText::_('MAIL_MSG');

		if ( JUtility::sendMail($from, $sender, null, $mail_sub, $mail_body, 1, null, $receivers) !== true) {
			return false;
		}

		return true;
	}
}
?>