<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMTag
{
	/**
	 * Creates a tag
	 *
	 * @param array		$array. Contains the message-ids
	 * @param string	$tag. The tag to add
	 * @access			public
	 * @return			array
	 */
	function Add($array, $tag)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');
		$ids		= implode( ',', $array);

		// 
		$tag		= strtolower($tag);
		$tag		= str_replace( array('"', "'"), array('&quot;', '&#39;'), $tag );

		// Get the existing tag-data if the tag exists
		$query		= "SELECT id, mids FROM `#__jam_tags` WHERE uid = $user_id AND tag = '$tag'";
		$db->setQuery($query);
		$result		= $db->loadObject();

		// Add the messages to the tag, if the tag exists
		if (isset($result->id))
		{
			$mids	= explode( ',', $result->mids );
			for ($i = 0, $t = count($array); $i < $t; $i++)
			{
				if (!in_array( $array[$i], $mids )) {
					$mids[] = $array[$i];
				}
			}

			// Filter for invalid keys
			if ($mids[0] == '') {
				unset($mids[0]);
			}
	
			$ids	= implode( ',', $mids );
			$query	= "UPDATE `#__jam_tags` SET mids = '$ids' WHERE id = $result->id";
			$db->setQuery($query);
			if (!$db->query()) {
				return $db->stderr();
			}
		}
		// Else create the tag
		else
		{
			$query	= "INSERT INTO `#__jam_tags` VALUES ('', '$user_id', '$tag', '$ids')";
			$db->setQuery($query);
			if (!$db->query()) {
				return $db->stderr();
			}
		}

		return true;
	}

	/**
	 * Untags messages with the selected tag
	 *
	 * @param array		$array. Contains the message-ids
	 * @param string	$tid. The tag-id
	 * @access			public
	 * @return			array
	 */
	function Un($array, $tid)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');

		// Get the existing tag-data
		$query		= 'SELECT mids FROM `#__jam_tags` WHERE id = '.$tid;
		$db->setQuery($query);
		$result		= $db->loadResult();

		// Untag the selected messages
		$mids = explode(',', $result);
		for ($i = 0, $t = count($array); $i < $t; $i++)
		{
			$key = array_search($array[$i], $mids);
			if ($key !== false) {
				unset($mids[$key]);
			}
		}

		// Save the new mids
		$mids = implode(',', $mids);
		$query	= "UPDATE `#__jam_tags` SET mids = '$mids' WHERE id = $tid";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		return true;
	}

	/**
	 * Cleans a tag
	 *
	 * @param array		$array. Contains the tag-ids
	 * @access			public
	 * @return			array
	 */
	function Clean($array)
	{
		$db		=& JFactory::getDBO();
		$ids	= implode( ',', $array);

		$query	= "UPDATE `#__jam_tags` SET mids = '' WHERE id IN ($ids);";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		return true;
	}

	/**
	 * Removes a tag
	 *
	 * @param array		$array. Contains the tag-ids
	 * @access			public
	 * @return			array
	 */
	function Delete($array)
	{
		$db		=& JFactory::getDBO();
		$ids	= implode( ',', $array);

		$query	= "DELETE FROM `#__jam_tags` WHERE id IN ($ids);";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		return true;
	}
}
?>