<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMSettings
{
	/**
	 * Saves the usersettings
	 *
	 * @parram array	$array. Contains the settings. Ordered by 'name'.
	 *					Look into the code to understand it
	 * @access			public
	 * @return			mixed
	 */
	 function General($array)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get( 'id');

		$update		= array(
						"template = '".$array['template']."'",
						"dateformat = '".$array['dateformat']."'",
						"notification = '".$array['notification']."'",
						"notification_message = '".$array['notification_message']."'"
					);

		$string		= implode( ',', $update);
		$query		= "UPDATE `#__jam_settings` SET $string WHERE userid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		// Reload the settings as they were updated
		JAMConfig::getUserSettings(true);

		return true;
	}

	/**
	 * Unblocks a user
	 *
	 * @parram array	$array. Contains the users-ids to unblock
	 * @access			public
	 * @return			mixed
	 */
	function Unblock($array)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get( 'id');

		// Get the blocked users
		$usersettings	= JAMConfig::getUserSettings();
		$blocked		= explode( ',', $usersettings->blocked );

		// do the appropiate action
		for ($i = 0, $t = count($array); $i < $t; $i++)
		{
			$key = array_search( $array[$i], $blocked );
			if ($key !== false) {
				unset( $blocked[$key] );
			}
		}

		// Filter for invalid keys
		for ($i = 0, $b = count($blocked); $i < $b; $i++)
		{
			if (!$blocked[$i]) {
				unset($blocked[$i]);
			}
		}
		
		// Save the blocked users
		$string		= implode( ',', $blocked);
		$query		= "UPDATE `#__jam_settings` SET blocked = '$string' WHERE userid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		// Reload the settings as they were updated
		JAMConfig::getUserSettings(true);

		return true;
	}
}
?>