<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMMove
{
	/**
	 * Moves the messages to the Archive
	 *
	 * @param array		$array. Contains the message-ids
	 * @access			public
	 * @return			mixed
	 */
	function Archive($array)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');
		$ids		= implode( ',', $array);

		$query		= "UPDATE `#__jam` SET outbox = '2' WHERE id IN ($ids) AND sid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		$query		= "UPDATE `#__jam_receivers` SET inbox = '2' WHERE mid IN ($ids) AND rid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		return true;
	}

	/**
	 * Moves the messages to the Trash
	 *
	 * @param array		$array. Contains the message-ids
	 * @access			public
	 * @return			mixed
	 */
	function Trash($array)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');
		$ids		= implode( ',', $array);

		$query		= "UPDATE `#__jam` SET outbox = CASE WHEN outbox = '1' THEN '-1' ELSE '-2' END WHERE id IN ($ids) AND sid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		$query		= "UPDATE `#__jam_receivers` SET inbox = CASE WHEN inbox = '1' THEN '-1' ELSE '-2' END WHERE mid IN ($ids) AND rid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		return true;
	}

	/**
	 * Moves the messages to their previous location
	 *
	 * @param array		$array. Contains the message-ids
	 * @access			public
	 * @return			mixed
	 */
	function Previous($array)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');
		$ids		= implode( ',', $array);

		$query		= "UPDATE `#__jam` SET outbox = CASE WHEN outbox = '-2' THEN '2' ELSE '1' END WHERE id IN ($ids) AND sid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		$query		= "UPDATE `#__jam_receivers` SET inbox = CASE WHEN inbox = '-2' THEN '2' ELSE '1' END WHERE mid IN ($ids) AND rid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		return true;
	}
}
?>