<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMMore
{
	/**
	 * Block the users of the selected messages
	 *
	 * @param array		$array. Contains the message-ids
	 * @access			public
	 * @return			array
	 */
	function Block($array)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');
		$ids		= implode( ',', $array);

		// Get the selected users to analyse
		$query		= 'SELECT m.sid, r.rid'
					. ' FROM `#__jam` AS m'
					. ' JOIN `#__jam_receivers` AS r ON (m.sid = '.$user_id.' OR r.rid = '.$user_id.') AND r.mid = m.id'
					. ' WHERE m.id IN ('.$ids.') OR r.mid IN ('.$ids.')';
		$db->setQuery($query);
		$result		= $db->loadAssocList();

		// Get the blocked users who are blocked already
		$usersettings	= JAMConfig::getUserSettings();
		$blocked		= explode( ',', $usersettings->blocked );

		// Analyse the selected users
		for ($i = 0, $t = count($result); $i < $t; $i++)
		{
			if ( $result[$i]['rid'] == $user_id )
			{
				if (!in_array( $result[$i]['sid'], $blocked )) {
					$blocked[] = $result[$i]['sid'];
				}
			} else
			{
				if (!in_array( $result[$i]['rid'], $blocked )) {
					$blocked[] = $result[$i]['rid'];
				}
			}
		}

		// Filter for invalid keys
		for ($i = 0, $b = count($blocked); $i < $b; $i++)
		{
			if (!$blocked[$i]) {
				unset($blocked[$i]);
			}
		}

		// Save the blocked users
		$string		= implode(',', $blocked);
		$query		= "UPDATE `#__jam_settings` SET blocked = '$string' WHERE userid = $user_id;";
		$db->setQuery($query);
		if (!$db->query()) {
			return $db->stderr();
		}

		// Reload the settings as they were updated
		JAMConfig::getUserSettings(true);

		return true;
	}

	/**
	 * Mail a message to receivers
	 *
	 * @param array		$array. Contains the message-ids
	 * @param string	$receivers. Contains the receivers
	 * @access			public
	 * @return			string
	 */
	 function Email($array, $receivers)
	 {
	 	// Load the email libraries
		jimport( 'joomla.mail.helper' );
		JAMLoad::_( 'librarie', 'email', 'site' );

		$receivers	= preg_replace( '@\s@', '', $receivers);
		$receivers	= explode( ';', $receivers);

		// Check for a valid addresses
		if (!$receivers[0])
		{
			$message = JText::_('PHPMAILER_PROVIDE_ADDRESS');
			return '<dl id="system-message"><dd class="notice"><ul><li>'.$message.'</li></ul></dd></dl>';
		}
		for ($i = 0, $t = count($receivers); $i < $t; $i++ )
		{
			if ($receivers[$i] == '') {
				unset( $receivers[$i] );
				continue;
			}
			if ( !JMailHelper::isEmailAddress($receivers[$i]) ) {
				$message = JText::sprintf('The address "%s" is not valid', $receivers[$i]);
				return '<dl id="system-message"><dd class="notice"><ul><li>'.$message.'</li></ul></dd></dl>';
			}
		}

		// Get the message
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');

		$query		= 'SELECT m.subject, m.message'
					. ' FROM `#__jam` AS m'
					. ' LEFT JOIN `#__jam_receivers` AS r ON r.mid = m.id AND r.rid = '.$user_id
					. ' WHERE m.id = '.$array[0].' AND (m.sid = '.$user_id.' OR r.rid = '.$user_id.')';
		$db->setQuery($query);
		$result		=& $db->loadObject();
		if (!isset($result->message)) {
			return '<dl id="system-message"><dd class="error"><ul><li>'.JText::_( 'ALERTNOTAUTH').'</li></ul></dd></dl>';
		}

		if ( !JAMEmail::EmailMessage($receivers, $result->subject, $result->message) )
		{
			$message = JText::_('The email(s) was / were not sent');
			return '<dl id="system-message"><dd class="error"><ul><li>'.$message.'</li></ul></dd></dl>';
		}

		$message = JText::_('The email(s) was / were sent');
		return '<dl id="system-message"><dd class="message"><ul><li>'.$message.'</li></ul></dd></dl>';
	 }
}
?>