<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMDelete
{
	/**
	 * Deletes messages
	 *
	 * @param array		$array. Contains the message-ids
	 * @access			public
	 * @return			array
	 */
	function Delete($array)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');
		$ids		= implode( ',', $array);

		$sender		= array();
		$receiver	= array();
		$delete		= array();
		$delete_a	= array();

		// Get the selected messages to analyse
		$query		= 'SELECT m.id, m.sid, m.outbox, m.attachments, MAX(r.inbox) AS inbox'
					. ' FROM `#__jam` AS m'
					. ' JOIN `#__jam_receivers` AS r ON (m.sid = '.$user_id.' OR r.rid = '.$user_id.') AND r.mid = m.id'
					. ' WHERE m.id IN ('.$ids.') OR r.mid IN ('.$ids.')'
					. ' GROUP BY m.id';
		$db->setQuery($query);
		$result		= $db->loadAssocList();

		// Analyse the selected users
		for ($i = 0, $t = count($result); $i < $t; $i++)
		{
			// User is the sender
			if ( $result[$i]['sid'] == $user_id )
			{
				if ($result[$i]['inbox']) {
					// Set the user's message to deleted
					$sender[] = $result[$i]['id'];
				} else {
					// Delete the message
					$delete[] = $result[$i]['id'];
					if ($result[$i]['attachments']) {$delete_a[] = $result[$i]['id'];}
				}
			// User is the receiver
			} else
			{
				if ($result[$i]['outbox']) {
					// Set the user's message to deleted
					$receiver[] = $result[$i]['id'];
				} else {
					// Delete the message
					$delete[] = $result[$i]['id'];
					if ($result[$i]['attachments']) {$delete_a[] = $result[$i]['id'];}
				}
			}
		}

		// Set the selected messages to deleted
		if ($sender)
		{
			$ids	= implode( ',', $sender);
			$query	= "UPDATE `#__jam` SET outbox = '0' WHERE id IN ($ids) AND sid = $user_id;";
			$db->setQuery($query);
			if (!$db->query()) {
				return $db->stderr();
			}
		}
		if ($receiver)
		{
			$ids	= implode( ',', $receiver);
			$query	= "UPDATE `#__jam_receivers` SET inbox = '0' WHERE mid IN ($ids) AND rid = $user_id;";
			$db->setQuery($query);
			if (!$db->query()) {
				return $db->stderr();
			}
		}

		// Delete the selected messages
		if ($delete)
		{
			$ids	= implode( ',', $delete);
			$query	= "DELETE FROM `#__jam` WHERE id IN ($ids);";
			$db->setQuery($query);
			if (!$db->query()) {
				return $db->stderr();
			}
			$query	= "DELETE FROM `#__jam_receivers` WHERE mid IN ($ids);";
			$db->setQuery($query);
			if (!$db->query()) {
				return $db->stderr();
			}
			
			// Delete the selected attachments
			if ($delete_a)
			{
				jimport('joomla.filesystem.folder');
				for ($i = 0, $t = count($delete_a); $i < $t; $i++)
				{
					JFolder::delete( JPATH_SITE.DS.'components'.DS.'com_jam'.DS.'attachments'.DS.$delete_a[$i] );
				}
			}
		}

		// Redirect to the Trash
		JRequest::setVar( 'view', 'trash', 'POST');

		return true;
	}
}
?>