<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

defined( '_JEXEC') or die('Restricted access'); // no direct access

// Load the loader librarie
require_once( JPATH_COMPONENT_SITE.DS.'libraries'.DS.'load.php');

// Only for users who are logged in AND who are allowed
$user	=& JFactory::getUser();
$config	=& JAMConfig::getConfig();
$gid	= $user->get('gid');
if ($gid < 18 || !$config->get('access_'.$gid) ) {
	if (JRequest::getInt('format') == 'raw') {
		jexit( JText::_('ALERTNOTAUTH') );
	} else {
		JError::raiseError( 403, JText::_('ALERTNOTAUTH') );
	}
}

// Get the task and the controller variable
$task		= JRequest::getWord('task', '', 'POST');
$controller	= JRequest::getWord('controller');

// Load the required controller
if ($task == 'savemessage') {
	$controller = 'controllers'.DS.'savemessage.php';
} else if ($task == 'action') {
	$controller = 'controllers'.DS.'action.php';
} else if ($controller == 'pure') {
	$controller = 'controllers'.DS.'pure.php';
} else if ($controller == 'attachment') {
	$controller = 'controllers'.DS.'savemessage.php';
	$task = 'attachment';
} else {
	global $mainframe;
	if ($mainframe->getUserState('attachments')) {
		JAMLoad::_( 'librarie', 'files', 'site');
		JAMFiles::RemoveUpload();
	}
	$controller = 'controller.php';
}
require_once( JPATH_COMPONENT.DS.$controller );

// Create the controller
$controller = new JAMController();

// Perform the requested task
$controller->execute( $task );

// Redirect if set by the controller
$controller->redirect();
?>