<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMUsers
{
	/**
	 * Returns a sql string for the user long
	 *
	 * @access			public
	 * @return			string
	 */
	function SQLUserLong()
	{
		static $string;

		if (!$string)
		{
			$config	=& JAMConfig::getConfig();
			$select	= $config->get('displayuser');

			// username
			if ($select == '1') {
				$string = 'u.username';
			}
			// name
			else if ($select == '2') {
				$string = 'u.name';
			}
			// username (name)
			else if ($select == '3') {
				$string = "CONCAT( u.username, ' (', u.name, ')' )";
			}
			// name (username)
			else if ($select == '4') {
				$string = "CONCAT( u.name, ' (', u.username, ')' )";
			}	
		}

		return $string;
	}

	/**
	 * Returns a sql string for the user short
	 *
	 * @access			public
	 * @return			string
	 */
	function SQLUserShort()
	{
		static $string;

		if (!$string)
		{
			$config	=& JAMConfig::getConfig();
			$select	= $config->get( 'displayuser');
	
			// username
			if ($select == '1' || $select == '3') {
				$string = 'u.username';
			}
			// name
			else if ($select == '2' || $select == '4') {
				$string = 'u.name';
			}
		}

		return $string;
	}
}
?>