<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMTemplate extends JObject
{
	/**
	 * The template name
	 *
	 * @var string
	 * @access public
	 */
	var $name;

	/**
	 * The template url
	 *
	 * @var string
	 * @access public
	 */
	var $url;

	/**
	 * The template directory
	 *
	 * @var string
	 * @access public
	 */
	var $dir;

	/**
	 * Class constructor
	 *
	 * @access private
	 */
	function __construct()
	{
		// Get the template's name
		$config			=& JAMConfig::getConfig();
		$usersettings	=& JAMConfig::getUserSettings();
		$name			= isset($usersettings->template) ? $usersettings->template : $config->get('template_default');
		if (!is_file( JPATH_PLUGINS.DS.'jam-templates'.DS.$name.DS.'template.php' )) {
			JError::raiseError( 500, 'Unable to load a template for JAM');
		}
		$this->name		= $name;

		$this->url	= JURI::root().'/plugins/jam-templates/'.$this->name.'/';
		$this->dir	= JPATH_PLUGINS.DS.'jam-templates'.DS.$this->name;
	}

	/**
	 * Returns a reference to a global JAMTemplate object, only creating it
	 * if it doesn't already exist.
	 *
	 * This method must be invoked as:
	 * 		<pre>$template =& JAMTemplate::getInstance();</pre>
	 *
	 * @static
	 * @access public
	 * @return object
	 */
	function &getInstance()
	{
		static $instance;

		if (!$instance) {
			$instance =& new JAMTemplate();
		}

		return $instance;
	}

	/**
	 * Executes a function within the template's folder
	 *
	 * @param string	$string.
	 * Additional arguments may be supplied and are passed to the sub-class.
	 * @access public
	 * $return mixed
	 */
	function &_($string)
	{
		// What function, class and file do we have?
		$parts	= explode( '.', $string);
		$func	= array_pop( $parts );
		$class	= $parts ? array_pop( $parts ) : null;
		$file	= $parts ? implode( DS, $parts) : null;

		// Load the class
		$path	= $class ? ($file ? $file.DS.$class : $class) : 'template';
		require_once( $this->dir.DS.$path.'.php' );

		// Execute the action
		$args = func_get_args();
		array_shift( $args );
		$return = call_user_func_array( array( 'JAMT'.$class, $func ), $args );

		return $return;
	}
}
?>