<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHeader
{
	/**
	 * Javascript stuff for the html header
	 *
	 * @access	public
	 * @return	boolean
	 */
	function _()
	{
		$config 	=& JAMConfig::getConfig();
		$document	=& JFactory::getDocument();
		$user		=& JFactory::getUser();
		$script		= "\t";

		// Language strings
		$script		.= "var jam_enterrequired = '".JText::_('Please enter (a) receiver(s), a subject and a message', true)."', "
					. "jam_messagelimit = '".JText::_('Your message is too long. Your message has {0} characters and the limit is {1} characters. Please shorten your message.', true)."', "
					. "jam_selectmessage = '".JText::_('Please select at least one message', true)."', "
					. "jam_selecttag = '".JText::_('Please select at least one tag', true)."', "
					. "jam_selectuser = '".JText::_('Please select at least one user', true)."', "
					. "jam_entertag = '".JText::_('Please enter a tag', true)."', "
					. "jam_send = '".JText::_('Send', true)."', "
					. "jam_save = '".JText::_('Save', true)."', "
					. "jam_massmessage = '".JText::_('Mass message', true)."', "
					. "sBrowseCaption = '".JText::_('Browse files', true)."', "
					. "sRemoveToolTip = '".JText::_('Remove', true)."', "
					. "jam_clearcompleted = '".JText::_('Clear completed', true)."';\n\t";

		// Settings
		$user_gid	= $user->get('gid');
		$script		.= 'var jam_lengthlimit = '.$config->get('lengthlimit_'.$user_gid).', '
					. 'jam_attachmentslimit = '.$config->get('attachments_'.$user_gid).', '
					. 'jam_attachmentsizelimit = '.$config->get('attachmentsizelimit_'.$user_gid).";\n\t";

		// Editor
		$editorname	= $user->getParam('editor');
		if ($editorname == 'none') {
			$editorscript	= '';
		}
		else if ($editorname == 'xstandard') {
			$editorscript	= 'var xstandard = new JXStandard();'
							. 'document.xstandard = xstandard;';
		} else {
			$editorname		= 'tinymce';
			$editorscript	= 'tinyMCE.idCounter=0;'
							. 'tinyMCE.execCommand( \'mceAddControl\', false, \'text\');'
							. 'if(window.ie6 || window.ie7){tinyMCE.focus(true)}';
		}
		$editor		=& JFactory::getEditor( $editorname );
		$editor->_loadEditor();
		$script		.= 'function JAMStartEditor() {'
					. $editorscript
					. "}\n\t";

		// keepAlive()
		$lifetime 	 = $config->getValue('lifetime') * 60000;
		$refreshTime = ( $lifetime <= 60000 ) ? 30000 : $lifetime - 60000;
		$script		.= 'window.addEvent(\'domready\', function() {'
					. 'try {JAMTReinitialize()} catch(e){}'
					. ' if (document.adminForm.view.value == \'new\') {JAMAttachments()}'
					. ' keepAlive.periodical('.$refreshTime.');'
					. '});';

		// Add js to the header
		$document->addScriptDeclaration( $script );
		JHTML::_('behavior.mootools');
		JHTML::script('ajax.js', 'components/com_jam/assets/');
		JHTML::script('new.js', 'components/com_jam/assets/');
		JHTML::script('swf.js');
		JHTML::script('uploader.js');

		return true;
	}
}
?>