<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

jimport('joomla.html.editor');

class JAMEditor extends JEditor
{
	/**
	 * Load the editor (Slightly modified to use it in ajax)
	 *
	 * @access private
	 * @since 1.5
	 */
	function _loadEditor()
	{
		//check if editor is already loaded
		if(!is_null(($this->_editor))) {
			return;
		}

		jimport('joomla.filesystem.file');

		// Build the path to the needed editor plugin
		$name = JFilterInput::clean($this->_name, 'cmd');
		$path = JPATH_SITE.DS.'plugins'.DS.'editors'.DS.$name.'.php';

		if ( ! JFile::exists($path) )
		{
			$message = JText::_('Cannot load the editor');
			JError::raiseWarning( 500, $message );
			return false;
		}

		// Require plugin file
		require_once $path;
		
		// Get the plugin
		$plugin =& JPluginHelper::getPlugin('editors', $this->_name);
		
		// Build editor plugin classname
		$name = 'plgEditor'.$this->_name;
		$this->_editor = new $name ($this, (array)$plugin);
	}
}