<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

class JAMActionmenu
{
	/**
	 * Returns the action menu items
	 *
	 * @parram array	$params. Contains the parameters
	 * @access			public
	 * @return			array
	 */
	function _($params)
	{
		$array = array();

		// Export
		if (isset($params['export']))
		{
			$baselink		= 'index.php?option=com_jam&controller=pure&view=export&tmpl=component&id='.$params['export'];
			$item			= JAMHtml::link( 'Export' );
			$item->children	= array(
								JAMHtml::link( 'Print',		'href="'.JRoute::_($baselink.'&layout=print').'"', true ),
								JAMHtml::link( 'PDF',		'href="'.JRoute::_($baselink.'&format=pdf').'"', true ),
								JAMHtml::link( 'E-mail',	'href="'.JRoute::_($baselink.'&layout=email').'"', true )
							);
			$array[]		= $item;
		}

		// Send
		if (in_array('send', $params))
		{
			$item			= JAMHtml::link( 'Send' );
			$children		= array();
			if (in_array('draft', $params)) {
				$children[] = JAMHtml::link( 'Send draft', 'href="javascript:void(0);" onclick="JAMAction(\'send\');"' );
			}
			if (in_array('reply', $params)) {
				$children[] = JAMHtml::link( 'Reply', 'href="javascript:void(0);" onclick="JAMAction(\'reply\');"' );
			}
			$children[] = JAMHtml::link( 'Forward', 'href="javascript:void(0);" onclick="JAMAction(\'forward\');"' );
			$item->children	= $children;
			$array[]		= $item;
		}

		// Move
		$item			= JAMHtml::link( 'Move' );
		$children		= array();
		if (in_array('archive', $params)) {
			$children[] = JAMHtml::link( 'Archive', 'href="javascript:void(0);" onclick="JAMAction(\'archive\');"' );
		}
		if (in_array('trash', $params)) {
			$children[] = JAMHtml::link( 'Trash', 'href="javascript:void(0);" onclick="JAMAction(\'trash\');"' );
		}
		if (in_array('previous', $params)) {
			$children[] = JAMHtml::link( 'Previous location', 'href="javascript:void(0);" onclick="JAMAction(\'previous\');"' );
		}
		$item->children	= $children;
		$array[]		= $item;

		// Delete
		if (in_array('delete', $params)) {
			$item			= JAMHtml::link( 'Delete', 'href="javascript:void(0);" onclick="JAMAction(\'delete\');"' );
			$item->children	= array();
			$array[]		= $item;
		}

		// More
		$item			= JAMHtml::link( 'More' );
		$children		= array();
		if (in_array('marknew', $params)) {
			$children[] = JAMHtml::link( 'Mark as new', 'href="javascript:void(0);" onclick="JAMAction(\'marknew\');"' );
		}
		if (in_array('markread', $params)) {
			$children[] = JAMHtml::link( 'Mark as read', 'href="javascript:void(0);" onclick="JAMAction(\'markread\');"' );
		}
		if (in_array('blocking', $params)) {
			$children[]	= JAMHtml::link( 'Block user(s)', 'href="javascript:void(0);" onclick="JAMAction(\'block\');"' );
		}
		if (in_array('blocking', $params) || in_array('markread', $params) || in_array('marknew', $params)) {
			$children[]	= JAMHtml::link( '--------' );
		}
		for ($i = 0, $t = count($params['tags']); $i < $t; $i++) {
			$children[]	= JAMHtml::link( JText::sprintf( 'Tag as %s', $params['tags'][$i]), 'href="javascript:void(0);" onclick="JAMTag(\''.$params['tags'][$i].'\');"' );
		}
		$children[]		= JAMHtml::link( 'New tag', 'href="javascript:void(0);" onclick="JAMTag();"' );
		if (isset($params['untag']) && $params['untag'])
		{
			$children[]	= JAMHtml::link( '--------' );
			for ($i = 0, $t = count($params['untag']); $i < $t; $i++) {
				$children[]	= JAMHtml::link( JText::sprintf( 'Remove tag %s', $params['untag'][$i]->tag), 'href="javascript:void(0);" onclick="JAMUntag(\''.$params['untag'][$i]->id.'\');"' );
			}
		}
		
		$item->children	= $children;
		$array[]		= $item;

		return $array;
	 }
}