<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

JAMLoad::_( 'includes', 'pagination', 'site' );

class JAMUsersPagination extends JAMPagination
{
	var $_url = null;

	function __construct( $total, $limitstart, $limit, $url)
	{
		$this->_url = $url.'&limitstart=';

		parent::__construct( $total, $limitstart, $limit); 
	}

	/**
	 * Create and return the pagination data object
	 *
	 * @access	public
	 * @return	object	Pagination data object
	 * @since	1.5
	 */
	function _buildDataObject()
	{
		// Initialize variables
		$data = new stdClass();

		$data->all	= new JPaginationObject(JText::_('View All'));
		if (!$this->_viewall) {
			$data->all->base	= '0';
			$data->all->link	= 'javascript:void(0);" onclick="JAMNewUsersearch(\''.$this->_url.'0\');';
		}

		// Set the start and previous data objects
		$data->start	= new JPaginationObject(JText::_('Start'));
		$data->previous	= new JPaginationObject(JText::_('Prev'));

		if ($this->get('pages.current') > 1)
		{
			$page = ($this->get('pages.current') -2) * $this->limit;
			$data->start->base	= '0';
			$data->start->link	= 'javascript:void(0);" onclick="JAMNewUsersearch(\''.$this->_url.'0\');';
			$data->previous->base	= $page;
			$data->previous->link	= 'javascript:void(0);" onclick="JAMNewUsersearch(\''.$this->_url.$page.'\');';
		}

		// Set the next and end data objects
		$data->next	= new JPaginationObject(JText::_('Next'));
		$data->end	= new JPaginationObject(JText::_('End'));

		if ($this->get('pages.current') < $this->get('pages.total'))
		{
			$page = $this->get('pages.current') * $this->limit;
			$endPage = ($this->get('pages.total') -1) * $this->limit;
			$data->next->base	= $page;
			$data->next->link	= 'javascript:void(0);" onclick="JAMNewUsersearch(\''.$this->_url.$page.'\');';
			$data->end->base	= $endPage;
			$data->end->link	= 'javascript:void(0);" onclick="JAMNewUsersearch(\''.$this->_url.$endPage.'\');';
		}

		$data->pages = array();
		$stop = $this->get('pages.stop');
		for ($i = $this->get('pages.start'); $i <= $stop; $i ++)
		{
			$offset = ($i -1) * $this->limit;
			$data->pages[$i] = new JPaginationObject($i);
			if ($i != $this->get('pages.current') || $this->_viewall)
			{
				$data->pages[$i]->base	= $offset;
				$data->pages[$i]->link	= 'javascript:void(0);" onclick="JAMNewUsersearch(\''.$this->_url.$offset.'\');';
			}
		}
		return $data;
	}
}
?>