<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHelperSettings
{
	/**
	 * Get the settings items
	 *
	 * @parram object	$settings. Contains the user his JAM settings
	 * @access			public
	 * @return			list
	 */
	function items( $settings)
	{
		$config		=& JAMConfig::getConfig();
		$user		=& JFactory::getUser();
		$gid		= $user->get('gid');
		$items		= array();

		// Template
		jimport('joomla.filesystem.folder');
		$templates	= JFolder::folders( JPATH_PLUGINS.DS.'jam-templates');
		$list		= array();
		foreach ($templates as $template)
		{
			$list[]				= JHTML::_( 'select.option', $template);
		}
		$action		= "document.getElementById('tntemplate').src='".JURI::root()."plugins/jam-templates/'+this.value+'/template_thumbnail.png'";
		$items[]	= JAMHtml::item(
						'Template',
						JHTML::_( 'select.genericlist', $list, 'template', 'class="inputbox" size="1" onclick="'.$action.'" style="vertical-align:top;"', 'value', 'text', $settings->template)
						. '<img id="tntemplate" src="'.JURI::root().'plugins/jam-templates/'.$settings->template.'/template_thumbnail.png" />',
						'TIP Template'
					);

		// Dateformat
		$list		= array();
		$list[]		= JHTML::_( 'select.option', '%d-%b-%Y %H:%M', JText::_( 'Day-Month-Year'));
		$list[]		= JHTML::_( 'select.option', '%b-%d-%Y %H:%M', JText::_( 'Month-Day-Year'));
		$items[]	= JAMHtml::item(
						'Date format',
						JHTML::_( 'select.genericlist', $list, 'dateformat', 'class="inputbox" size="1"', 'value', 'text', $settings->dateformat),
						'TIP Date format'
					);

		// Notification Email
		if ( $config->get('notification_'.$gid) )
		{
			$items[]	= JAMHtml::item(
							'Notification email',
							JHTML::_( 'select.booleanlist', 'notification', 'class="inputbox"', $settings->notification),
							'TIP Notification email'
						);
		}

		// Notification Email with message
		if ( $config->get('notification_message') && $config->get('notification_'.$gid) )
		{
			$items[]	= JAMHtml::item(
							'Notification includes message',
							JHTML::_( 'select.booleanlist', 'notification_message', 'class="inputbox"', $settings->notification_message),
							'TIP Notification includes message'
						);
		}

		// Tags
		$items[]	= JAMHtml::item(
						'Tags',
						$settings->tags
					);

		// Blocked users
		if ( $settings->blocked !== false )
		{
			$items[]	= JAMHtml::item(
							'Blocked users',
							$settings->blocked,
							'TIP Blocked users'
						);
		}

		return $items;
	}
}