<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHelperNew
{
	/**
	 * Get the message options items
	 *
	 * @access			public
	 * @return			array
	 */
	function items()
	{
		$config		=& JAMConfig::getConfig();
		$user		=& JFactory::getUser();
		$gid		= $user->get('gid');
		$items		= array();

		// Draft message
		$items[]	= JAMHtml::item(
						'Draft',
						JHTML::_( 'select.booleanlist', 'draft', 'class="inputbox" onclick="JAMNewDraft(this.value)"', 0),
						'TIP Draft'
					);

		// Priority
		$selected	= JRequest::getVar( 'priority', 2, 'POST', 'INT');
		$list		= array();
		$list[]		= JHTML::_( 'select.option', 3, JText::_( 'High'));
		$list[]		= JHTML::_( 'select.option', 2, JText::_( 'Normal'));
		$list[]		= JHTML::_( 'select.option', 1, JText::_( 'Low'));
		$items[]	= JAMHtml::item(
						'Priority',
						JHTML::_('select.genericlist', $list, 'priority', 'class="inputbox" size="1"', 'value', 'text', $selected)
					);

		// Mass message
		if (  $config->get('massmessage_'.$gid) )
		{
			$items[]	= JAMHtml::item(
							'Mass message',
							JHTML::_( 'select.booleanlist', 'mass', 'class="inputbox" onclick="JAMNewMass(this.value);"', 0),
							'TIP Mass message'
						);

			$list		= array();
			$list[]		= JHTML::_( 'select.option', 0, JText::_( 'None'));
			$list[]		= JHTML::_( 'select.option', 18, JText::_( 'Registred'));
			$list[]		= JHTML::_( 'select.option', 19, JText::_( 'Author'));
			$list[]		= JHTML::_( 'select.option', 20, JText::_( 'Editor'));
			$list[]		= JHTML::_( 'select.option', 21, JText::_( 'Publisher'));
			$list[]		= JHTML::_( 'select.option', 23, JText::_( 'Manager'));
			$list[]		= JHTML::_( 'select.option', 24, JText::_( 'Administrator'));
			$list[]		= JHTML::_( 'select.option', 25, JText::_( 'Super Administrator'));
			$items[]	= JAMHtml::item(
							'Group message',
							JHTML::_( 'select.genericlist', $list, 'groups[]', 'class="inputbox" size="8" multiple="multiple" onchange="JAMNewGroup();"', 'value', 'text', 0, 'groups'),
							'TIP Group message'
						);
		}

		// System message
		if ( $config->get('systemmessage_'.$gid) )
		{
			$selected	= JRequest::getVar( 'system', 0, 'POST', 'INT');
			$items[]	= JAMHtml::item(
							'System message',
							JHTML::_( 'select.booleanlist', 'system', 'class="inputbox"', $selected),
							'TIP System message'
						);
		}

		// Information message
		if ( $config->get('informationmessage_'.$gid) )
		{
			$selected	= JRequest::getVar( 'information', 0, 'POST', 'INT');
			$items[]	= JAMHtml::item(
							'Information message',
							JHTML::_( 'select.booleanlist', 'information', 'class="inputbox" onclick="JAMNewInformation(this.value);"', $selected),
							'TIP Information message'
						);
		}

		// Attachments
		if ( $attachments = $config->get('attachments_'.$gid) )
		{
			$limit		= $config->get('attachmentsizelimit_'.$gid) / 1024;
			$sizelimit	= $limit >= 1024 ? ($limit/1024).' '.JText::_('MB') : $limit.' '.JText::_('KB');
			$data		= '<div id="attachments">'
						. '<input type="file" name="attachment" id="JAMAttachment" /> '
						. '<span id="upload-clear"></span>'
						. '<ul id="upload-queue"></ul>'
						. '<br />'.JText::_( 'Max attachment size').': '.$sizelimit
						. '</div>';
			$items[]	= JAMHtml::item(
							'Attachments',
							$data
						);
		}

		return $items;
	}

	/**
	 * Get data for the page
	 *
	 * @parram string	$action. Contains the action
	 * @parram object	$result. Contains the message where the action if for
	 * @access			public
	 * @return			array
	 */
	function getData($action, &$result)
	{
		if ($action == 'send')
		{
			$receivers		= $result->user ? $result->user.';' : '';
			$subject		= stripslashes($result->subject);
			$message		= stripslashes($result->message);
		} else
		{
			$config			=& JAMConfig::getConfig();
			$select			= $config->get('displayuser');
			$user			=& JFactory::getUser();
			if ($select == '1') {
				$self = $user->get('username');
			} else if ($select == '2') {
				$self = $user->get('name');
			} else if ($select == '3') {
				$self = $user->get('username').' ('.$user->get('name').')';
			} else if ($select == '4') {
				$self = $user->get('name').' ('.$user->get('username').')';
			}

			if ($action == 'reply')
			{
				$receivers	= $result->user.';';
				$subject	= 'RE: '.stripslashes($result->subject);

				$from		= $result->user;
				$to			= $self;				
			}
			else if ($action == 'forward')
			{
				$receivers	= '';
				$subject	= 'FW: '.stripslashes($result->subject);

				if ($result->sid == $user->get('id')) {
					$from	= $self;
					$to		= $result->user;
				} else {
					$from	= $result->user;
					$to		= $self;
				}
			}

			$message		= "<br /><br />\n"
							. "<hr />\n"
							. '<b>'.JText::_( 'Sent at').	':</b> '.$result->datetime."<br />\n"
							. '<b>'.JText::_( 'From').		':</b> '.$from."<br />\n"
							. '<b>'.JText::_( 'To').		':</b> '.$to."<br />\n"
							. '<b>'.JText::_( 'Subject').	':</b> '.stripslashes($result->subject)."<br /><br />\n"
							. stripslashes($result->message);
		}

		return array( 'receivers' => $receivers, 'subject' => $subject, 'message' => $message);
	}
}