<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

JAMLoad::_( 'helper', 'box', 'site' );

class JAMHelperInbox extends JAMHelperBox
{
	/**
	 * Filter tags
	 *
	 * @param int	$ids. Contains the selected message-ids
	 * @access		public
	 * @return		string
	 */
	function Filter_tags($ids)
	{
		$string = "r.mid IN ($ids)";
		return $string;
	}

	/**
	 * Filter state html
	 *
	 * @parram int		$state. Contains the state-parameters
	 * @access			public
	 * @return			string
	 */
	function Filter_state_html($state)
	{
		return parent::Filter_state_html( $state, array('newread', 'information') );
	}

	/**
	 * Returns the action menu items
	 *
	 * @param array		$tags
	 * @access			public
	 * @return			array
	 */
	function MenuItems($tags)
	{
		JAMLoad::_( 'includes', 'actionmenu', 'site' );
		$config		=& JAMConfig::getConfig();

		$params		= array( 'markread', 'marknew', 'archive', 'trash', 'tags' => $tags, ($config->get('blocking') ? 'blocking' : 0) );
		$actions	= JAMActionmenu::_($params);

		return $actions;
	}
}