<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

class JAMHelperBox
{
	/**
	 * Process the rows, to prepare them for the output
	 *
	 * @parram array	$rows.
	 * @access			public
	 * @return			array
	 */
	function Process($rows)
	{
		$usersettings	=& JAMConfig::getUserSettings();
		$user			=& JFactory::getUser();

		$user_id		= $user->get('id');
		$user_timezone	= $user->getParam('timezone', '0');
		$notfound		= JText::_('Not found');
		$draft			= JText::_('Draft');

		for ($i = 0, $t = count($rows); $i < $t; $i++)
		{
			// Make sure there is both a sid and a rid
			$rows[$i]->rid		= isset($rows[$i]->rid) ? $rows[$i]->rid : $user_id;
			$rows[$i]->sid		= isset($rows[$i]->sid) ? $rows[$i]->sid : $user_id;
			$rows[$i]->draft	= isset($rows[$i]->draft) ? $rows[$i]->draft : 0;

			// Username(s)
			if ($rows[$i]->draft && $rows[$i]->sid == $user_id) {
				$rows[$i]->user = $draft.($rows[$i]->user ? ': '.$rows[$i]->user : '');
			} else {
			 	$rows[$i]->user = $rows[$i]->user ? $rows[$i]->user : $notfound;
			}

			// Subject and messagepart
			$rows[$i]->subject	= stripslashes($rows[$i]->subject);
			$rows[$i]->message	= stripslashes( strip_tags($rows[$i]->message) );
			if (strlen($rows[$i]->message) >= 90) {
				$rows[$i]->message .= '&hellip;';
			}

			// Link
			$rows[$i]->link = 'href="#'.$rows[$i]->subject.'" onclick="JAMRead(\''.$rows[$i]->id.'\')";';

			// Convert the message date and time in the user's prefferred format
			$rows[$i]->datetime = JHTML::Date($rows[$i]->datetime, $usersettings->dateformat, $user_timezone);
		}

		return $rows;
	}

	/**
	 * SQL Search part
	 *
	 * @parram string	$string.
	 * @access			public
	 * @return			string
	 */
	function SQLSearch($search)
	{
		$config	=& JAMConfig::getConfig();
		$display= $config->get( 'displayuser');
		$array	= explode( ' ', $search);
		$parts	= array();
			
		for ($i = 0, $t = count($array); $i < $t; $i++)
		{
			$part = $array[$i];

			if ($display == '3' || $display == '4') {
				$parts[]	= "((u.username LIKE '%$part%' OR u.name LIKE '%$part%')"
							. " OR m.subject LIKE '%$search%'"
							. " OR m.message LIKE '%$search%')";
			} else {
				$parts[]	= "( ".JAMUsers::SQLUserShort()." LIKE '%$part%'"
							. " OR m.subject LIKE '%$search%'"
							. " OR m.message LIKE '%$search%')";
			}
		}

		$string = implode( ' AND ', $parts);
		return '('.$string.')';
	}


	/**
	 * Filter tags html
	 *
	 * @parram array	$tags. Contains the tags
	 * @parram array	$tag. Contains the selected tag
	 * @access			public
	 * @return			string
	 */
	function Filter_tags_html($tags, $tag)
	{
		$list	= array();
		$list[] = JHTML::_( 'select.option', '', JText::_( 'All') );
		for ($i = 0, $t = count($tags); $i < $t; $i++)
		{
			if (!$tags[$i]) {
				continue;
			}
			$list[] = JHTML::_( 'select.option', $tags[$i] );
		}

		return JHTML::_( 'select.genericlist', $list, 'filter_tag', 'size="1" class="inputbox" onchange="JAMAjaxCommon();"', 'value', 'text', $tag);
	}

	/**
	 * Filter state
	 *
	 * @parram int	$filter. Contains the parram for the filter
	 * @access		public
	 * @return		string
	 */
	function Filter_state($filter)
	{
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');

		// New
		if ($filter == '1') {
			$where = "(r.rid = '$user_id' AND r.state = '0')";
		}
		// Read
		else if ($filter == '2') {
			$where = "(r.rid = '$user_id' AND r.state = '1')";
		}
		// Draft
		else if ($filter == '3') {
			$where = "(m.sid = '$user_id' AND m.draft = '1')";
		}
		// System
		else if ($filter == '4') {
			$where = "m.system = '1'";
		}
		// Information message
		else if ($filter == '5') {
			$where = "m.sid = '1'";
		}
		// Received
		else if ($filter == '10') {
			$where = "r.rid = '$user_id'";
		}
		// Sent
		else if ($filter == '11') {
			$where = "m.sid = '$user_id'";
		}

		return $where;
	}

	/**
	 * Filter state html
	 *
	 * @parram int		$state. Contains the state-parameters
	 * @parram array	$array. Contains the list-parameters (optional)
	 * @access			public
	 * @return			string
	 */
	function Filter_state_html($state, $array = array())
	{
		$list = array();
		$list[] = JHTML::_( 'select.option', '0', JText::_( 'All') );
		if (in_array( 'newread', $array )) {
			$list[] = JHTML::_( 'select.option', '1', JText::_( 'New') );
			$list[] = JHTML::_( 'select.option', '2', JText::_( 'Read') );
		}
		if (in_array( 'draft', $array )) {
			$list[] = JHTML::_( 'select.option', '3', JText::_( 'Draft') );
		}
		$list[] = JHTML::_( 'select.option', '4', JText::_( 'System message') );
		if (in_array( 'information', $array )) {
			$list[] = JHTML::_( 'select.option', '5', JText::_( 'Information message') );
		}
		if (in_array( 'received', $array )) {
			$list[] = JHTML::_( 'select.option', '10', JText::_( 'Received') );
		}
		if (in_array( 'sent', $array )) {
			$list[] = JHTML::_('select.option', '11', JText::_( 'Sent') );
		}

		return JHTML::_( 'select.genericlist', $list, 'filter_state', 'size="1" class="inputbox" onchange="JAMAjaxCommon();"', 'value', 'text', $state);
	}

	/**
	 * Filter order html
	 *
	 * @parram string	$order. Contains the list-parameter
	 * @access			public
	 * @return			string
	 */
	function Filter_order_html($order)
	{
		$list = array();
		$list[] = JHTML::_( 'select.option', JAMUsers::SQLUserShort(),	JText::_( 'User'));
		$list[] = JHTML::_( 'select.option', 'm.subject',				JText::_( 'Subject'));
		$list[] = JHTML::_( 'select.option', 'm.datetime',				JText::_( 'Date and Time'));

		return JHTML::_( 'select.genericlist', $list, 'filter_order', 'size="1" class="inputbox" onchange="JAMAjaxCommon();"', 'value', 'text', $order);
	}

	/**
	 * Filter order Dir html
	 *
	 * @parram string	$dir. Contains the list-parameter
	 * @access			public
	 * @return			string
	 */
	function Filter_order_Dir_html($dir)
	{
		$list = array();
		$list[] = JHTML::_( 'select.option', 'ASC',		JText::_( 'Ascending'));
		$list[] = JHTML::_( 'select.option', 'DESC',	JText::_( 'Descending'));

		return JHTML::_( 'select.genericlist', $list, 'filter_order_Dir', 'size="1" class="inputbox" onchange="JAMAjaxCommon();"', 'value', 'text', $dir);
	}

	/**
	 * Messages left with more info if necessary
	 *
	 * @parram int	$amount. The amount of messages of the user
	 * @access		public
	 * @return		string
	 */
	function MessagesLeft($amount)
	{
		$config	=& JAMConfig::getConfig();
		$user	=& JFactory::getUser();
		$amount	= $config->get('messageslimit_'.$user->get('gid')) - $amount;

		$string = JText::sprintf( 'You may still receive %d messages', $amount);

		// Warning if necessary
		if ($amount < 1) {
			$string .= '<br /><span class="jam-spacewarning">'.JText::_( 'You do not have anymore space available. You can only send messages and receive system-messages. Please create space by deleting (old) messages.').'</span>';
		} else if ($amount < 6) {
			$string .= '<br /><span class="jam-spacewarning">'.JText::_( 'You are running out of space! Please create space by deleting (old) messages.').'</span>';
		}

		return $string;
	}
}