<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.controller');

class JAMController extends JController
{
	function savemessage()
	{
		// Load some libraries
		JAMLoad::_( 'librarie', 'messages', 'site');
		JAMLoad::_( 'librarie', 'receivers', 'site');

		global $mainframe;
		$config		=& JAMConfig::getConfig();
		$user		=& JFactory::getUser();
		$user_id	= $user->get('id');
		$user_gid	= $user->get('gid');

		$return		=& new StdClass();
		$return->m	= null;
		$return->t	= 'message';

		// Get message data
		$receivers	= preg_replace( '@\(.*?\)@si', '',
						JRequest::getVar( 'receivers', '', 'POST')
					);
		$mass		= JRequest::getVar( 'mass', 0, 'POST', 'INT');
		$groups		= JRequest::getVar( 'groups', 0, 'POST', 'ARRAY');
		$subject	= JRequest::getVar( 'subject', 0, 'POST', 'STRING');
		$message	= JRequest::getVar( 'text', 0, 'POST', 'STRING', JREQUEST_ALLOWRAW);
		$datetime	= JHTML::Date( gmdate('Y-m-d H:i:s'), '%Y-%m-%d %H:%M:%S');
		$options	= array(
						'draft' => JRequest::getVar( 'draft', 0, 'POST', 'INT'),
						'priority' => JRequest::getVar( 'priority', 2, 'POST', 'INT'),
						'system' => JRequest::getVar( 'system', 0, 'POST', 'INT'),
						'information' => JRequest::getVar( 'information', 0, 'POST', 'INT'),
						'attachments' => $mainframe->getUserState('attachments')
					);
		$filter		= ($options['system'] || $options['information']) ? false : true;

		/**
		 * Some checks to make sure everything is ok
		 */
		// Remove any javascript code
		$subject	= preg_replace( '@<script[^>]*?>.*?</script>@si', ' ', $subject);
		$message	= preg_replace( '@<script[^>]*?>.*?</script>@si', ' ', $message);

		// Make sure there are no attachments on a draft message
		if ($options['attachments'] && $options['draft'])
		{
			JAMLoad::_( 'librarie', 'files', 'site');

			// Remove the attachments
			JAMFiles::RemoveUpload();
			$options['attachments'] = 0;
		}

		/**
		 * Get the ids of the receivers
		 */
		// If we have a "mass message", get all the valid users
		if ($mass)
		{
			$receivers = JAMReceivers::getAllValidUsers();
		}
		else
		{
			// Create an array
			$receivers	= explode( ';', $receivers);
			// Filter the input to handable stuff
			for ($i = 0, $t = count($receivers); $i < $t; $i++)
			{
				// Remove unnecessary spaces
				$receivers[$i] = trim($receivers[$i]);
				// Remove key if empty
				if ($receivers[$i] == '') {
					unset($receivers[$i]);
				}
			}
			// Get the ids of the selected users
			$valid = JAMReceivers::getValidIds($receivers);
			if (count($valid) != count($receivers)) {
				$return->m	.= JText::_('Invalid receiver(s) removed').'<br />';
				$return->t	= 'notice';
			}
			$receivers = $valid;

			// Get the users from the selected groups if neccesary
			if ($groups)
			{
				$users		= JAMReceivers::getValidIdsFromGroup( $groups);
				$receivers	= array_merge( $receivers, $users);
				// Remove possible duplicate users
				$receivers	= array_unique( $receivers );
			}
		}
		
		// Check if we have receivers
		if ( !$receivers & !$options['draft'] ) {
			$this->ReturnPage( 'new', JText::_( 'No users found'), 'notice');
			return;
		}

		/**
		 * Get data of the receivers
		 */
		// Create a receivers string
		$receivers_string = implode( ',', $receivers );

		if ($receivers_string)
		{
			$db				=& JFactory::getDBO();
			$select			= JAMUsers::SQLUserLong();
			if (count($receivers) < 10) {
			 	$query		= 'SELECT u.id, u.gid, '.$select.' AS `user`, u.email, u.params, s.notification, s.notification_message, s.blocked';
			} else {
				$query		= 'SELECT u.id, u.gid, 0 AS `user`, u.email, 0 AS `params`, 0 AS `notification`, 0 AS `notification_message`, s.blocked';
			}
			$query			.= ' FROM `#__users` AS u'
							. ' LEFT JOIN `#__jam_settings` AS s ON s.userid = u.id'
							. ' WHERE u.id IN ('.$receivers_string.')';
			$db->setQuery($query);
			$receivers_data	= $db->loadAssocList();
		}
		else {
			$receivers_data	= array();
		}

		/**
		 * Filter the receivers in necessary
		 * - If they have no space left
		 * - If they have blocked the sender
		 */

		// This array may contain the users who will not receive the message
		$notsent = array();

		if ($filter && $receivers_string)
		{
			// Get the amount of the messages by receivers
			$db->setQuery( 'SELECT COUNT(*) AS amount, sid FROM `jos_jam` WHERE sid IN ('.$receivers_string.') AND outbox != 0 GROUP BY sid');
			$sent = $db->loadAssocList('sid');
			$db->setQuery( 'SELECT COUNT(*) AS amount, rid FROM `jos_jam_receivers` WHERE rid IN ('.$receivers_string.') AND inbox != 0 GROUP BY rid');
			$received = $db->loadAssocList('rid');

			$receivers = array();

			for ($i = 0, $r = count($receivers_data); $i < $r; $i++)
			{
				$uid	= $receivers_data[$i]['id'];
				$amount	= 0;

				// Count the messages
				if (isset( $sent[$uid] )) {
					$amount += $sent[$uid]['amount'];
				}
				if (isset( $received[$uid] )) {
					$amount += $received[$uid]['amount'];
				}

				// Has the processed receiver blocked the sender?
				if ($config->get('blocking')) {
					$blocklist	= explode( ',', $receivers_data[$i]['blocked']);
					$blocked	= in_array( $user_id, $blocklist);
				}
				else {
					$blocked	= false;
				}

				// Remove the receiver from the list if necessary
				if ( $amount >= $config->get('messageslimit_'.$receivers_data[$i]['gid']) || $blocked ) {
					$notsent[] = $receivers_data[$i]['user'];
					unset($receivers_data[$i]);
				}
				else {
					$receivers[] = $uid;
				}
			}

			sort($receivers_data);
		}

		/**
		 * Store the message in the database
		 */
		// "Write" the message if there are receivers and the message is not a draft
		if ($receivers && !$options['draft'])
		{
			$result = JAMMessages::Write( $receivers, addslashes($subject), addslashes($message), $datetime, $options );
			if ( $result !== true ) {
				$this->ReturnPage( 'inbox', $result, 'error');
				return;
			}
			$return->m .= JText::_( 'Your message was sent');

			// Inform the user if a receiver did not receive the message
			if ($notsent)
			{
				if (!isset($notsent[1])) {
					$return->m .= '<br />'.JText::sprintf('%s has not received your message as %s has no space available', $notsent[0], $notsent[0] );
				} else {
					$last	= array_pop($notsend);
					$return->m .= '<br />'.JText::sprintf('%s and %s have not received your message as they have no space available', implode( ', ', $notsent), $last );
				}
				$return->t = 'notice';
			}

			// Analyse the receivers for who should receive a notification email
			$email = array();
			$notif_message = $config->get('notification_message');
			$notif_system = $config->get('notification_system');
			$notif_system_message = $config->get('notification_system_message');
			for ($i = 0, $r = count($receivers_data); $i < $r; $i++)
			{
				$receiver = $receivers_data[$i];

				if ( ($receiver['notification'] && $config->get('notification_'.$receiver['gid'])) || ($options['system'] && $notif_system) )
				{
					$params = new JParameter( $receiver['params'] );
					$email[]= array(
								'user' => $receiver['user'],
								'email' => $receiver['email'],
								'language' => $params->get('language', 'en-GB'),
								'includemessage' => ($notif_message && $receiver['notification_message']) || ($options['system'] && $notif_system_message)
							);
				}
			}
			
			// Send the emails
			if ($email && JAMLoad::_('librarie', 'email', 'site') && !JAMEmail::EmailAlert( $email, $subject, $message, $options )) {
				$return->m .= '<br />'.JText::_( 'The notification email(s) was / were not sent' );
				$return->t	= 'notice';
			}

		// "Save" the message if there are no receivers or if the message is a draft
		} else
		{
			$result = JAMMessages::Draft( $receivers, addslashes($subject), addslashes($message), $datetime, $options );
			if ( $result !== true ) {
				$this->ReturnPage( 'inbox', $result, 'error');
			}

			if ($notsent & !$options['draft'])
			{
				// Inform the user if the message was not sent, because there were no valid users
				if (!isset($notsent[1])) {
					$return->m .= JText::sprintf( '%s has not received your message as %s has no space available. Therefore your message was saved in your Outbox.', $notsent[0], $notsent[0] );
					$return->t	= 'notice';
				} else {
					$last	= array_pop($notsend);
					$return->m .= JText::sprintf( '%s and %s have not received your message as they have no space available. Therefore your message was saved in your Outbox.', implode( ', ', $return), $last );
					$return->t = 'notice';
				}
			} else
			{
				$return->m .= JText::_( 'Your message was saved in your Outbox');
			}
		}

		$this->ReturnPage( 'inbox', $return->m, $return->t);
	}

	function ReturnPage($viewName, $message, $type = 'message')
	{
		echo '<div id="jammessage"><dl id="system-message"><dd class="'.$type.'"><ul><li>'.$message.'</li></ul></dd></dl></div>';

		/**
		 * Load a view
		 */
		// Get the view
		$view		=& $this->getView( $viewName, 'raw');
		// Set the layout
		$view->setLayout('default');
		// Add the template object
		$template	=& JAMTemplate::getInstance();
		$view->template = $template;
		// Add the template path
		$view->addTemplatePath($template->dir.DS.'html'.DS.$viewName);

		/**
		 * Display the view
		 */
		$view->display();
	}

	function Attachment()
	{
		JAMLoad::_( 'librarie', 'files', 'site');
		jimport('joomla.filesystem.file');

		// Get a file
		$file = JRequest::getVar( 'Filedata', '', 'files', 'array' );

		// Make sure we have a file
		$file['name'] = JFile::makeSafe($file['name']);
		if (!$file['name']) {
			header('HTTP/1.0 415 Unsupported Media Type');
			die('Error. Unsupported Media Type!');
		}

		// Move the file to a folder
		if (!JAMFiles::Upload($file)) {
			header('HTTP/1.0 500 Unable to upload file');
			die('Error. Unable to upload file');
		}

		// Everything is done
		die('Upload complete');
	}
}
?>