<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.controller');

class JAMController extends JController
{
	function action()
	{
		// Get some variables
		$mids	= JRequest::getVar( 'mid', false, 'POST', 'ARRAY');
		$action	= JRequest::getVar( 'action', NULL, 'POST', 'WORD');
		$view	= JRequest::getVar( 'view', 'inbox', 'POST', 'WORD');

		if ($action == 'reply' || $action == 'forward' || $action == 'send') {
			$this->ReturnPage( 'new');
			return;
		}

		if ($action == 'marknew') {
			JAMLoad::_( 'librarie', 'actions.mark', 'site');

			$return = JAMMark::AsNew($mids);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Succesfully marked as "new"') );
			return;
		}

		if ($action == 'markread')
		{
			JAMLoad::_( 'librarie', 'actions.mark', 'site');

			$return = JAMMark::AsRead($mids);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Succesfully marked as "read"') );
			return;
		}

		if ($action == 'archive')
		{
			JAMLoad::_( 'librarie', 'actions.move', 'site');

			$return = JAMMove::Archive($mids);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully moved to the Archive') );
			return;
		}

		if ($action == 'trash')
		{
			JAMLoad::_( 'librarie', 'actions.move', 'site');

			$return = JAMMove::Trash($mids);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully moved to the Trash') );
			return;
		}

		if ($action == 'previous')
		{
			JAMLoad::_( 'librarie', 'actions.move', 'site');

			$return = JAMMove::Previous($mids);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully moved to the previous location') );
			return;
		}

		if ($action == 'delete')
		{
			JAMLoad::_( 'librarie', 'actions.delete', 'site');

			$return = JAMDelete::Delete($mids);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( 'trash', JText::_('Succesfully deleted') );
			return;
		}

		if ($action == 'tag')
		{
			JAMLoad::_( 'librarie', 'actions.tag', 'site');

			$tag = JRequest::getString( 'tag', '', 'POST');

			$return = JAMTag::Add($mids, $tag);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully tagged') );
			return;
		}

		if ($action == 'untag')
		{
			JAMLoad::_( 'librarie', 'actions.tag', 'site');

			$tid = JRequest::getVar( 'tag', '', 'POST', 'INT');

			$return = JAMTag::Un($mids, $tid);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully untagged') );
			return;
		}

		if ($action == 'block')
		{
			JAMLoad::_( 'librarie', 'actions.more', 'site');

			$return = JAMMore::Block($mids);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully blocked') );
			return;
		}

		if ($action == 'email')
		{
			JAMLoad::_( 'librarie', 'actions.more', 'site');

			$receivers = JRequest::getVar( 'receivers', NULL, 'POST', 'STRING');
			echo JAMMore::Email($mids, $receivers);
			return;
		}

		if ($action == 'savesettings')
		{
			JAMLoad::_( 'librarie', 'actions.settings', 'site');

			// Get form variables
			$array							= array();
			$array['template']				= JRequest::getVar( 'template', 0, 'POST', 'STRING');
			$array['dateformat']			= JRequest::getVar( 'dateformat', '%d-%b-%Y %H:%M', 'POST', 'STRING');
			$array['notification']			= JRequest::getVar( 'notification', 0, 'POST', 'INT');
			$array['notification_message']	= $array['notification'] ? JRequest::getVar( 'notification_message', 0, 'POST', 'INT') : 0;

			$return = JAMSettings::General($array);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully saved') );
			return;
		}

		if ($action == 'deletetag')
		{
			JAMLoad::_( 'librarie', 'actions.tag', 'site');

			$array	= JRequest::getVar( 'tid', NULL, 'POST', 'ARRAY');
			$return = JAMTag::Delete($array);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully removed tag') );
			return;
		}

		if ($action == 'unblock')
		{
			JAMLoad::_( 'librarie', 'actions.settings', 'site');

			$array	= JRequest::getVar( 'uid', NULL, 'POST', 'ARRAY');
			$return = JAMSettings::Unblock($array);
			if ( $return !== true ) {
				$this->ReturnPage( $view, $return, 'error' );
				return;
			}

			$this->ReturnPage( $view, JText::_('Successfully unblocked') );
			return;
		}

		$this->ReturnPage( $view);
	}

	function ReturnPage($viewName, $message = false, $type = 'message')
	{
		if ($message) {
			echo '<div id="jammessage"><dl id="system-message"><dd class="'.$type.'"><ul><li>'.$message.'</li></ul></dd></dl></div>';
		}

		/**
		 * Load a view
		 */
		// Get the view
		$view		=& $this->getView( $viewName, 'raw');
		// Set the layout
		$view->setLayout('default');
		// Add the template object
		$template	=& JAMTemplate::getInstance();
		$view->template = $template;
		// Add the template path
		$view->addTemplatePath($template->dir.DS.'html'.DS.$viewName);

		/**
		 * Display the view
		 */
		$view->display();
	}
}
?>