<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.controller');

class JAMController extends JController
{
	function display()
	{
		$document	=& JFactory::getDocument();
		$template	=& JAMTemplate::getInstance();

		// Say welcome to the user if he does not have any settings
		if ( !JAMConfig::getUserSettings() ) {
			JRequest::setVar( 'view', 'welcome');
		}

		/**
		 * Load a view
		 */
		// Get some vars for the view
		$viewName	= JRequest::getVar( 'view', 'inbox');
		$viewLayout = JRequest::getVar( 'layout', 'default');
		$viewType   = $document->getType();
		// Get the view
		$view =& $this->getView( $viewName, $viewType);
		// Set the layout
		$view->setLayout($viewLayout);
		// Add the template object
		$view->template = $template;
		// Add the template path
		$view->addTemplatePath($template->dir.DS.'html'.DS.$viewName);

		/**
		 * Add various stuff in the <head>
		 */
		$document->SetTitle( Jtext::_('Joomla Advanced Message'));
		$template->_('initialize');
		JHTML::_('behavior.mootools');
		if ($viewName == 'inbox' || $viewName == 'new' || $viewName == 'read' || $viewName == 'welcome') {
			// Add more stuff in the <head>
			JAMLoad::_( 'includes', 'header', 'site');
			JAMHeader::_();
		}

		/**
		 * Display the view
		 */
		echo '<div id="upload-swf"></div><div id="jam">';
		$view->display();
		echo '</div>'
			. '<noscript>'.JText::_( 'Warning! You must enable javascript in order to properly use JAM').'</noscript>';
	}

	function ReturnPage()
	{
		/**
		 * Load a view
		 */
		// Get some vars for the view
		$viewName	= JRequest::getVar( 'view', 'inbox', 'POST', 'STRING');
		$viewLayout = JRequest::getVar( 'layout', 'default');
		// Get the view
		$view		=& $this->getView( $viewName, 'raw');
		// Set the layout
		$view->setLayout( $viewLayout);
		// Add the template object
		$template	=& JAMTemplate::getInstance();
		$view->template = $template;
		// Add the template path
		$view->addTemplatePath($template->dir.DS.'html'.DS.$viewName);

		/**
		 * Display the view
		 */
		$view->display();
	}
}
?>