<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewTemplates extends JView
{
	function display( $tpl = null)
	{
		$layout = $this->getLayout();
		if ($layout == 'editor') {
			$this->_editor($tpl);
			return;
		} else if ($layout == 'fileslist') {
			$this->_fileslist($tpl);
			return;
		} else {
			$this->_default($tpl);
			return;
		}
	}

	function _default($tpl)
	{
		JAMLoad::_( 'helper', 'templates' );
		JHTML::_('behavior.tooltip', '.hasTip', array('fixed' => 1) );
		$config =& JAMConfig::getConfig();
		$default= $config->get('template_default');

		// Get template data
		jimport('joomla.filesystem.folder');
		$rows		= array();
		$templates	= JFolder::folders( JPATH_PLUGINS.DS.'jam-templates');
		foreach ($templates as $template) {
			$data = JAMHelperTemplates::getTemplateInfo($template);
			$data->name = $template;
			$data->default = (strtolower($data->name) == $default) ? '<img src="./images/tick.png" />' : '';
			$rows[] = $data;
		}

		$this->assign( 'rows', $rows);

		parent::display($tpl);
	}

	function _fileslist($tpl)
	{
		$array		= JRequest::getVar( 'cid', '', 'post', 'array');
		if (!$array) {
			global $mainframe;
			$this->_mainframe->redirect( 'index.php?option=com_jam&view=templates', JText::_('File not found'), 'error' );
		}

		$template	= JPATH_PLUGINS.DS.'jam-templates'.DS.$array[0];
		$path		= JRequest::getVar( 'path', 'css', 'post');
		$basepath	= $template.DS.$path;

		// Get files data
		jimport('joomla.filesystem.folder');
		$filter		= $path == 'html' ? 'php' : 'css';
		$rows		= JFolder::files( $basepath, "\.$filter$", true, true );
		for ($i = 0, $t = count($rows), $l = strlen($basepath)+1; $i < $t; $i++) {
			$rows[$i] = substr( $rows[$i], $l);
		}

		$this->assign( 'rows', $rows);
		$this->assign( 'basepath', $basepath);
		$this->assign( 'template', $array[0]);
		$this->assign( 'path', $path);

		parent::display($tpl);
	}

	function _editor($tpl)
	{
		$template	= JRequest::getVar( 'template', '', 'post');
		$path		= JRequest::getVar( 'path', '', 'post');
		$basepath	= JPATH_PLUGINS.DS.'jam-templates'.DS.$template.DS.$path;
		
		// Read the source file
		jimport('joomla.filesystem.file');
		$array		= JRequest::getVar( 'cid', '', 'post', 'array');
		$file		= $array[0];
		$content	= JFile::read( $basepath.DS.$file);

		$this->assign( 'fullpath', $basepath.DS.$file);
		$this->assign( 'content', $content);
		$this->assign( 'template', $template);
		$this->assign( 'path', $path);
		$this->assign( 'file', $file);

		parent::display($tpl);
	}
}
?>