<?php
/**
* @Component: JAM - Joomla Advanced Message - A Joomla Component.
* @Copyright: (c) Cas de Vroom. All rights reserved.
* @Information: See INFORATION.txt for the license, website, etc
*/

jimport('joomla.application.component.view');

class JAMViewStatistics extends JView
{
	function display( $tpl = null)
	{
		$model		=& JAMLoad::Object( 'model', 'statistics');
		$helper		=& JAMLoad::Object( 'helper', 'statistics');
		
		$data_m		= $model->tableMessages();

		if ($data_m->total)
		{
			/* Create the output data */
			// General
			$general					= array();
			$general['total']			= $data_m->total;
			$general['tablesize']		= $model->getTablesSize();
			$general['draft']			= $helper->getProcent( $data_m->draft,		$data_m->total );
			$general['information']		= $helper->getProcent( $data_m->information,$data_m->total );
			$general['system']			= $helper->getProcent( $data_m->system,		$data_m->total );
			$general['attachments'] 	= $helper->getProcent( $data_m->attachments,$data_m->total );
			$general['attachmentssize']	= $helper->getSizeAttachmentsFolder();

			// Top 5
			$top					= array();
			$top['receivers']		= $model->getTopReceivers();
			$top['senders']			= $model->getTopSenders();

			// Receivers
			$data_r					= $model->tableReceivers();
			$receivers				= array();
			$receivers['total']		= $helper->getProcent( $data_r->total,	$data_m->total );
			$receivers['average']	= round( $data_r->total / $data_m->total );
			$receivers['archive']	= $helper->getProcent( $data_r->archive,$data_r->total );
			$receivers['trash']		= $helper->getProcent( $data_r->trash,	$data_r->total );
			$receivers['new']		= $helper->getProcent( $data_r->s_new,	$data_r->total );
			$receivers['read']		= $helper->getProcent( $data_r->s_read,	$data_r->total );

			// Senders
			$senders				= array();
			$senders['total']		= $helper->getProcent( $data_m->senders,	$data_m->total );
			$senders['archive']		= $helper->getProcent( $data_m->archive,	$data_m->senders );
			$senders['trash']		= $helper->getProcent( $data_m->trash,		$data_m->senders );

			// Tags
			$data_t					= $model->tableTags();
			$tags					= array();
			$tags['total']			= $data_t->total;

			$this->assign( 'general',	$general);
			$this->assign( 'top',		$top);
			$this->assign( 'receivers',	$receivers);
			$this->assign( 'senders',	$senders);
			$this->assign( 'tags',		$tags);
		} else {
			$this->assign( 'general',	0);
		}

		parent::display($tpl);
	}
}
?>